package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bidprice.material.bean.*;
import com.ejianc.business.bidprice.material.service.*;
import com.ejianc.business.bidprice.material.vo.*;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bidprice.material.mapper.MaterialPicketageMapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料定标
 * 
 * @author generator
 * 
 */
@Service("materialPicketageService")
public class MaterialPicketageServiceImpl extends BaseServiceImpl<MaterialPicketageMapper, MaterialPicketageEntity> implements IMaterialPicketageService{
    @Autowired
    private IMaterialPicketageSupplierService supplierService;
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IMaterialInquiryService inquiryService;
    @Autowired
    private IMaterialQuoteService quoteService;
    @Override
    public boolean insertOrUpdate(MaterialPicketageEntity entity) {
        List<MaterialPicketageSupplierEntity> supplierList = new ArrayList<>();
        Boolean success = super.saveOrUpdate(entity,false);
        if(success){
            if(!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList()) ){
                entity.getMaterialPicketagePurchaseDetailList().forEach(sub->{
                    supplierList.addAll(sub.getMaterialPicketageSupplierList());
                });
                entity.getMaterialPicketageRentDetailList().forEach(sub->{
                    supplierList.addAll(sub.getMaterialPicketageSupplierList());
                });
            }
            if (CollectionUtils.isNotEmpty(supplierList)){
                supplierService.saveOrUpdateBatch(supplierList);
            }
        }
        return true;
    }

    @Override
    public void pushPicketage(Long billId) {
        MaterialPicketageEntity entity = service.selectById(billId);
        //自制
        if (entity.getSelfFlag()==0){
            MaterialResultEntity materialResultEntity = builderResultEntity(entity);
            materialResultService.saveOrUpdate(materialResultEntity,false);
        }

    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper<MaterialResultEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("picketage_id",billId);
        List<MaterialResultEntity> list = materialResultService.list(wrapper);
        service.removeByIds(list.stream().map(MaterialResultEntity::getId).collect(Collectors.toList()),true);
    }

    public MaterialResultEntity builderResultEntity( MaterialPicketageEntity entity){
        MaterialResultEntity result = new MaterialResultEntity();
        List<MaterialResultPurchaseDetailEntity> purchaseList = new ArrayList<>();
        List<MaterialResultRentDetailEntity> rentList = new ArrayList<>();

        result.setPicketageId(entity.getId());
        if (StringUtils.isNotEmpty(entity.getBidWinnerId())){
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        result.setPricingTypeName(entity.getPricingType()==1 ? "采购" : "租赁");

        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPricingType()==1 ? "项目自采" : "公司集采");
        result.setBillCode(entity.getBillCode());

        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketagePurchaseDetailList()) || CollectionUtils.isNotEmpty(entity.getMaterialPicketageRentDetailList())){
            Map<Long, MaterialPicketageSupplierEntity> winSupplierMap=new HashMap<>();
            if (StringUtils.isNotEmpty(entity.getBidWinnerId())){
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId",new Parameter(QueryParam.EQ,Long.parseLong(entity.getBidWinnerId())));
                List<MaterialPicketageSupplierEntity> supplierEntities = supplierService.queryList(param, false);
                 winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k->k.getPicketageDetailId(),(k)->k));
            }
            for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                MaterialResultPurchaseDetailEntity resultPurchase = new MaterialResultPurchaseDetailEntity();
                resultPurchase.setMaterialCategoryId(purchase.getMaterialCategoryId());
                resultPurchase.setMaterialCategoryName(purchase.getMaterialCategoryName());
                resultPurchase.setMaterialId(purchase.getMaterialId());
                resultPurchase.setMaterialName(purchase.getMaterialName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                if (!winSupplierMap.isEmpty()){
                    MaterialPicketageSupplierEntity materialPicketageSupplierEntity = winSupplierMap.get(purchase.getId());
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    resultPurchase.setBidMny(materialPicketageSupplierEntity.getMny());
                }
                resultPurchase.setBidPrice(new BigDecimal(1));
                purchaseList.add(resultPurchase);
            }
            for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                MaterialResultRentDetailEntity resultRent = new MaterialResultRentDetailEntity();
                resultRent.setMaterialCategoryId(rent.getMaterialCategoryId());
                resultRent.setMaterialCategoryName(rent.getMaterialCategoryName());
                resultRent.setMaterialId(rent.getMaterialId());
                resultRent.setMaterialName(rent.getMaterialName());
                resultRent.setSpec(rent.getSpec());
                resultRent.setUnit(rent.getUnit());
                resultRent.setResidueNum(rent.getNum());
                resultRent.setReferPrice(rent.getReferPrice());
                resultRent.setRentterm(rent.getRentTerm());
                resultRent.setRentMode(rent.getRentMode());
                resultRent.setRentterm(rent.getRentTerm());
                resultRent.setSourceId(rent.getId());

                resultRent.setBidPrice(new BigDecimal(1));
                if (!winSupplierMap.isEmpty()){
                    MaterialPicketageSupplierEntity materialPicketageSupplierEntity = winSupplierMap.get(rent.getId());
                    resultRent.setBidNum(rent.getNum());
                    resultRent.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    resultRent.setBidMny(materialPicketageSupplierEntity.getMny());
                }
                rentList.add(resultRent);
            }
        }
        if (CollectionUtils.isNotEmpty(rentList) || CollectionUtils.isNotEmpty(purchaseList)){
            result.setMaterialResultRentDetailList(rentList);
            result.setMaterialResultPurchaseDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Long, BigDecimal> collect = new HashMap<>();
        //查询 询价子表清单
        MaterialInquiryEntity materialInquiryEntity = inquiryService.selectById(inquiryId);
        MaterialInquiryVO inquiryVO = BeanMapper.map(materialInquiryEntity, MaterialInquiryVO.class);
        if (inquiryVO.getPricingType().equals(new Integer(1))){
            collect = inquiryVO.getMaterialInquiryPurchaseDetailList().stream().collect(
                    Collectors.toMap(MaterialInquiryPurchaseDetailVO::getId, MaterialInquiryPurchaseDetailVO::getNum));
            jsonObject.put("purchaseList",inquiryVO.getMaterialInquiryPurchaseDetailList());
        }else {
            collect = inquiryVO.getMaterialInquiryRentDetailList().stream().collect(
                    Collectors.toMap(MaterialInquiryRentDetailVO::getId, MaterialInquiryRentDetailVO::getNum));
            jsonObject.put("rentList",inquiryVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap",collect);

        //查询 报价
        LambdaQueryWrapper<MaterialQuoteEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(MaterialQuoteEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdaQueryWrapper.eq(MaterialQuoteEntity::getInquiryId,inquiryId);
        lambdaQueryWrapper.in(MaterialQuoteEntity::getBillState,
                new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List<MaterialQuoteEntity> list = quoteService.list(lambdaQueryWrapper);
        jsonObject.put("quoteList",BeanMapper.mapList(list, MaterialQuoteVO.class));

        return CommonResponse.success("查询数据成功！",jsonObject);

    }
}
