package com.ejianc.business.bidprice.material.service.impl;

import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Service("materialQuote")
public class MaterialQuoteBpmServiceImpl implements ICommonBusinessService {

	@Resource
	private IBillTypeApi billTypeApi;
	@Resource
	private IMaterialQuoteService materialQuoteService;


	/**
	 * 提交完回调
	 *
	 * @param billId       报价单id
	 * @param state        单据状态
	 * @param billTypeCode 单据类型编码
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		MaterialQuoteEntity entity = materialQuoteService.selectById(billId);
		if (entity == null) {
			return CommonResponse.error("该报价单不存在！");
		}
		// 生成报价时间
		entity.setQuoteTime(new Date());
		materialQuoteService.updateById(entity);
		return CommonResponse.success();
	}

}
