/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"materialQuote"})
@Api(tags={"\u6750\u6599\u62a5\u4ef7\u8bb0\u5f55"})
public class MaterialQuoteController
implements Serializable {
    private static final long serialVersionUID = -6476701269896286249L;
    private static final String RULE_CODE = "MATERIAL_QUOTE";
    private static final String BILL_CODE = "BT202302000002";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IMaterialQuoteService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<MaterialQuoteVO> saveOrUpdate(@RequestBody MaterialQuoteVO materialQuoteVO) {
        MaterialQuoteEntity entity = (MaterialQuoteEntity)((Object)BeanMapper.map((Object)materialQuoteVO, MaterialQuoteEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)materialQuoteVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialQuoteVO vo = (MaterialQuoteVO)BeanMapper.map((Object)((Object)entity), MaterialQuoteVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetail"})
    public CommonResponse<MaterialQuoteVO> queryDetail(Long id) {
        MaterialQuoteEntity entity = (MaterialQuoteEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u62a5\u4ef7\u8bb0\u5f55\u6570\u636e\uff01");
        }
        MaterialQuoteVO vo = (MaterialQuoteVO)BeanMapper.map((Object)((Object)entity), MaterialQuoteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<MaterialQuoteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialQuoteVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<MaterialQuoteVO>> queryList(@RequestBody QueryParam param) {
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialQuoteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/shareQrCode"})
    public CommonResponse<JSONObject> shareQrCode(@RequestParam(value="inquiryId") Long inquiryId) {
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u62a5\u4ef7\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f\uff01", (Object)this.service.generateQrCode(inquiryId));
    }

    @GetMapping(value={"/fetchVerifyCode"})
    public CommonResponse<Void> fetchVerifyCode(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="dialog", required=false) Boolean dialog) throws Exception {
        this.service.fetchVerifyCode(inquiryId, phoneNumber, dialog);
        return CommonResponse.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/login"})
    public CommonResponse<String> login(@RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="validate") String validate) {
        this.service.login(phoneNumber, validate);
        return CommonResponse.success((String)"\u767b\u5f55\u6210\u529f\uff01", (Object)phoneNumber);
    }

    @ApiOperation(value="\u6536\u56de")
    @GetMapping(value={"/withdraw"})
    public CommonResponse<String> withdraw(@RequestParam(value="id") Long id) {
        this.service.withdraw(id);
        return CommonResponse.success((String)"\u6536\u56de\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u5355\u636e\u72b6\u6001")
    @GetMapping(value={"/changeStatus"})
    public CommonResponse<String> changeStatus(@RequestParam(value="id") Long id, @RequestParam(value="billState") Integer billState) {
        this.service.changeStatus(id, billState);
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6700\u8fd1\u4e00\u6b21\u7684\u62a5\u4ef7\u8bb0\u5f55")
    @GetMapping(value={"/recentQuote"})
    public CommonResponse<MaterialQuoteVO> recentQuote(@RequestParam(value="phoneNumber") String phoneNumber) {
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01", (Object)this.service.recentQuote(phoneNumber));
    }
}

