/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuotePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inquiryCommonService")
public class InquiryCommonService {
    @Autowired
    private IMaterialInquiryService materialInquiryService;
    @Autowired
    private IMaterialQuoteService materialQuoteService;
    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;

    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        MaterialInquiryEntity byId = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
        InquiryCommonVO inquiryCommonVO = (InquiryCommonVO)BeanMapper.map((Object)((Object)byId), InquiryCommonVO.class);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MaterialQuoteEntity::getInquiryId, (Object)inquiryId);
        List list = this.materialQuoteService.list((Wrapper)queryWrapper);
        List materialQuoteVOS = BeanMapper.mapList((Iterable)list, MaterialQuoteVO.class);
        inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
        if (CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) {
            List quoteIds = materialQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (inquiryCommonVO.getPricingType() == 1) {
                LambdaQueryWrapper purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List purchaseDetailEntityList = this.materialQuotePurchaseDetailService.list((Wrapper)purchaseDetailEntityLambdaQueryWrapper);
                List materialQuotePurchaseDetailVOS = BeanMapper.mapList((Iterable)purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);
                Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));
                List materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();
                for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                    materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId()));
                }
            }
        }
        return inquiryCommonVO;
    }
}

