package com.ejianc.business.bidprice.material.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;

/**
 * 材料定标
 * 
 * @author generator
 * 
 */
public interface IMaterialPicketageService extends IBaseService<MaterialPicketageEntity> {

    boolean insertOrUpdate(MaterialPicketageEntity entity);

    void pushPicketage(Long billId);

    void rollBackPicketage(Long billId);

    /**
     *  根据询价单 id 查询 询价清单 和报价记录
     * @param inquiryId
     * @return 询价清单--{purchaseList、rentList} 报价记录--{quoteList} 清单数量统计--{totalMap}
     */
    CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId);
}
