package com.ejianc.business.bidprice.material.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuotePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description: 询价公共服务
 * @author songlx
 * @date 2023/2/8
 * @version 1.0
 */

@Service("inquiryCommonService")
public class InquiryCommonService {

    @Autowired
    private IMaterialInquiryService materialInquiryService;

    @Autowired
    private IMaterialQuoteService materialQuoteService;


    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;

    /**
     * @description: 查询各个阶段的询价详情
     *
     * @param inquiryId
     * @param inquiryState
     * @param inquiryType
     * @return {@link InquiryCommonVO}
     * @author songlx
     * @date: 2023/2/8
     */
    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        MaterialInquiryEntity byId = materialInquiryService.selectById(inquiryId);
        InquiryCommonVO inquiryCommonVO = BeanMapper.map(byId, InquiryCommonVO.class);

        LambdaQueryWrapper<MaterialQuoteEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialQuoteEntity::getInquiryId, inquiryId);
        List<MaterialQuoteEntity> list = materialQuoteService.list(queryWrapper);
        List<MaterialQuoteVO> materialQuoteVOS = BeanMapper.mapList(list, MaterialQuoteVO.class);
        inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
        if (CollectionUtils.isNotEmpty(materialQuoteVOS)) {
            List<Long> quoteIds = materialQuoteVOS.stream().map(MaterialQuoteVO::getId).collect(Collectors.toList());
            //采购
            if (inquiryCommonVO.getPricingType() == 1) {
                LambdaQueryWrapper<MaterialQuotePurchaseDetailEntity> purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List<MaterialQuotePurchaseDetailEntity> purchaseDetailEntityList = materialQuotePurchaseDetailService.list(purchaseDetailEntityLambdaQueryWrapper);
                List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailVOS = BeanMapper.mapList(purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);

                Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));

                List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();

                for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                    materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId()));
                }

            } else {

            }

        }

        return inquiryCommonVO;
    }
}
