package com.ejianc.business.bidprice.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bidprice.material.mapper.MaterialInquiryMapper;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;

import java.util.Date;

/**
 * 材料询价
 * 
 * @author generator
 * 
 */
@Service("materialInquiryService")
public class MaterialInquiryServiceImpl extends BaseServiceImpl<MaterialInquiryMapper, MaterialInquiryEntity> implements IMaterialInquiryService{

    @Override
    public MaterialInquiryVO updateInquiry(MaterialInquiryVO updateVo) {
        Long id = updateVo.getId();
        Date quoteEndDate = updateVo.getQuoteEndDate();
        //是否截止标志
        Boolean quoteEndFlag = updateVo.getQuoteEndFlag();
        MaterialInquiryEntity entity = super.selectById(id);
        if(entity != null){
            LambdaUpdateWrapper<MaterialInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(MaterialInquiryEntity::getId,id);
            updateWrapper.set(MaterialInquiryEntity::getQuoteEndDate,quoteEndDate);
            //如果截止，修改询价状态为已截止
            if(quoteEndFlag){
                updateWrapper.set(MaterialInquiryEntity::getInquiryState, InquiryStateEnum.EXPIRATION_STATE.getCode());
            }
            super.update(updateWrapper);
        }
        return updateVo;
    }
}
