package com.ejianc.business.bidprice.material.service;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.consts.InquiryTypeConsts;
import com.ejianc.business.bidprice.material.bean.*;
import com.ejianc.business.bidprice.material.vo.*;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description: 询价公共服务
 * @author songlx
 * @date 2023/2/8
 * @version 1.0
 */

@Service("inquiryCommonService")
public class InquiryCommonService {

    @Autowired
    private IMaterialInquiryService materialInquiryService;

    @Autowired
    private IMaterialQuoteService materialQuoteService;


    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;

    @Autowired
    private IMaterialQuoteRentDetailService materialQuoteRentDetailService;

    @Autowired
    private IMaterialContractApi materialContractApi;

    @Autowired
    private IRmatContractApi rmatContractApi;

    @Autowired
    private IMaterialResultService materialResultService;


    /**
     * @description: 查询各个阶段的询价详情
     *
     * @param inquiryId
     * @param inquiryState
     * @param inquiryType
     * @return {@link InquiryCommonVO}
     * @author songlx
     * @date: 2023/2/8
     */
    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        MaterialInquiryEntity byId = materialInquiryService.selectById(inquiryId);
        InquiryCommonVO inquiryCommonVO = BeanMapper.map(byId, InquiryCommonVO.class);

        LambdaQueryWrapper<MaterialQuoteEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialQuoteEntity::getInquiryId, inquiryId);
        List<MaterialQuoteEntity> list = materialQuoteService.list(queryWrapper);
        List<MaterialQuoteVO> materialQuoteVOS = BeanMapper.mapList(list, MaterialQuoteVO.class);
        inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
        if (CollectionUtils.isNotEmpty(materialQuoteVOS)) {
            Map<Long, List<MaterialQuoteVO>> supplierQuoteMap = materialQuoteVOS.stream().collect(Collectors.groupingBy(MaterialQuoteVO::getSupplierId));


            HashMap<Long, String> supplierNameMap = new HashMap<>();
            for (Long key : supplierQuoteMap.keySet()) {
                List<MaterialQuoteVO> valueList = supplierQuoteMap.get(key);
                if (valueList.size() > 1) {
                    int i = 1;
                    for (MaterialQuoteVO materialQuoteVO : valueList) {
                        materialQuoteVO.setSupplierName(materialQuoteVO.getSupplierName() + " (方案" + i++ + ")");
                        supplierNameMap.put(materialQuoteVO.getId(), materialQuoteVO.getSupplierName());
                    }
                } else {
                    supplierNameMap.put(valueList.get(0).getId(), valueList.get(0).getSupplierName());
                }
            }

            List<Long> quoteIds = new ArrayList<>(supplierNameMap.keySet());
            //采购
            if (inquiryCommonVO.getPricingType() == 1) {
                LambdaQueryWrapper<MaterialQuotePurchaseDetailEntity> purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List<MaterialQuotePurchaseDetailEntity> purchaseDetailEntityList = materialQuotePurchaseDetailService.list(purchaseDetailEntityLambdaQueryWrapper);
                List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailVOS = BeanMapper.mapList(purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);

                if (CollectionUtils.isNotEmpty(materialQuotePurchaseDetailVOS)) {
                    materialQuotePurchaseDetailVOS.forEach(t -> t.setSupplierName(supplierNameMap.get(t.getQuoteId())));
                    Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));

                    List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();

                    for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                        materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId()));
                    }
                }


                //租赁
            } else {
                LambdaQueryWrapper<MaterialQuoteRentDetailEntity> rentDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                rentDetailEntityLambdaQueryWrapper.in(MaterialQuoteRentDetailEntity::getQuoteId, quoteIds);
                List<MaterialQuoteRentDetailEntity> rentDetailEntityList = materialQuoteRentDetailService.list(rentDetailEntityLambdaQueryWrapper);
                List<MaterialQuoteRentDetailVO> materialQuoteRentDetailVOS = BeanMapper.mapList(rentDetailEntityList, MaterialQuoteRentDetailVO.class);

                if (CollectionUtils.isNotEmpty(materialQuoteRentDetailVOS)) {
                    materialQuoteRentDetailVOS.forEach(t -> t.setSupplierName(supplierNameMap.get(t.getQuoteId())));
                    Map<Long, List<MaterialQuoteRentDetailVO>> rentQuoteMap = materialQuoteRentDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuoteRentDetailVO::getSourceId));

                    List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList = inquiryCommonVO.getMaterialInquiryRentDetailList();

                    for (MaterialInquiryRentDetailVO materialInquiryRentDetailVO : materialInquiryRentDetailList) {
                        materialInquiryRentDetailVO.setMaterialQuoteRentDetailVOList(rentQuoteMap.get(materialInquiryRentDetailVO.getId()));
                    }
                }

            }

        }

        return inquiryCommonVO;
    }

    public JSONObject queryContractListByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        JSONObject resObj = new JSONObject();
        LambdaQueryWrapper<MaterialResultEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MaterialResultEntity::getInquiryId, inquiryId);
        List<MaterialResultEntity> list = materialResultService.list(wrapper);
        if(CollectionUtils.isEmpty(list)){
            return resObj;
        }
        List<Long> ids = list.stream().map(MaterialResultEntity::getId).collect(Collectors.toList());
        if (InquiryTypeConsts.MATERIAL.equals(inquiryType)) {
            CommonResponse<List<MaterialContractVO>> resp = materialContractApi.getContractByCondition(ids);
            resObj.put("contractList", resp.getData());
        } else if (InquiryTypeConsts.RMAT.equals(inquiryType)) {
            CommonResponse<List<RentContractVO>> resp = rmatContractApi.getContractByCondition(ids);
            resObj.put("contractList", resp.getData());

        }

        return resObj;
    }
}
