package com.ejianc.business.bidprice.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.bidprice.material.vo.MaterialPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bidprice.material.mapper.MaterialInquiryMapper;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料询价
 * 
 * @author generator
 * 
 */
@Service("materialInquiryService")
public class MaterialInquiryServiceImpl extends BaseServiceImpl<MaterialInquiryMapper, MaterialInquiryEntity> implements IMaterialInquiryService{

    @Autowired
    private MaterialInquiryMapper materialInquiryMapper;

    @Override
    public MaterialInquiryVO updateInquiry(MaterialInquiryVO updateVo) {
        Long id = updateVo.getId();
        Date quoteEndDate = updateVo.getQuoteEndDate();
        //是否截止标志
        Boolean quoteEndFlag = updateVo.getQuoteEndFlag();
        MaterialInquiryEntity entity = super.selectById(id);
        if(entity != null){
            LambdaUpdateWrapper<MaterialInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(MaterialInquiryEntity::getId,id);
            updateWrapper.set(MaterialInquiryEntity::getQuoteEndDate,quoteEndDate);
            //如果截止，修改询价状态为已截止
            if(quoteEndFlag){
                updateWrapper.set(MaterialInquiryEntity::getInquiryState, InquiryStateEnum.EXPIRATION_STATE.getCode());
            }
            super.update(updateWrapper);
        }
        return updateVo;
    }

    @Override
    public MaterialPriceVO queryPrice(MaterialPriceVO vo) {
        List<MaterialPriceVO> detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            //历史低价和高价只和租户有关
            List<MaterialPriceVO> materialPrices = materialInquiryMapper.queryPriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds);
            if (CollectionUtils.isNotEmpty(materialPrices)) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVO.get(materialId);
                    if (null != p) {
                        v.setMinPrice(p.getMinPrice());
                        v.setMaxPrice(p.getMaxPrice());
                        v.setPriceArea(p.getMinPrice().setScale(2, BigDecimal.ROUND_HALF_UP) + "~" + p.getMaxPrice().setScale(2, BigDecimal.ROUND_HALF_UP));

                    }
                }
            }
        }
        return vo;
    }

}
