/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteRentDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuotePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inquiryCommonService")
public class InquiryCommonService {
    @Autowired
    private IMaterialInquiryService materialInquiryService;
    @Autowired
    private IMaterialQuoteService materialQuoteService;
    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;
    @Autowired
    private IMaterialQuoteRentDetailService materialQuoteRentDetailService;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        InquiryCommonVO inquiryCommonVO;
        block16: {
            HashMap<Long, String> supplierNameMap;
            List quoteIds;
            block17: {
                MaterialInquiryEntity inquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
                MaterialInquiryVO materialInquiryVO = (MaterialInquiryVO)BeanMapper.map((Object)((Object)inquiryEntity), MaterialInquiryVO.class);
                this.materialInquiryService.queryMaterialPrice(materialInquiryVO);
                inquiryCommonVO = (InquiryCommonVO)BeanMapper.map((Object)materialInquiryVO, InquiryCommonVO.class);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MaterialQuoteEntity::getInquiryId, (Object)inquiryId);
                List list = this.materialQuoteService.list((Wrapper)queryWrapper);
                List materialQuoteVOS = BeanMapper.mapList((Iterable)list, MaterialQuoteVO.class);
                inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
                if (!CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) break block16;
                quoteIds = materialQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
                JSONObject fileParam = new JSONObject();
                fileParam.put("sourceIds", quoteIds);
                JSONArray sourceTypeArr = new JSONArray();
                sourceTypeArr.add((Object)"quote");
                fileParam.put("sourceTypeList", (Object)JSONObject.toJSONString((Object)sourceTypeArr));
                CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
                List fileData = (List)listCommonResponse.getData();
                Map<Object, Object> fileMap = new HashMap();
                if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                    fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(MaterialResultEntity::getQuoteId, quoteIds);
                List resultEntityList = this.materialResultService.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)resultEntityList)) {
                    Object sumBidMny = BigDecimal.ZERO;
                    Map<Long, MaterialResultEntity> resultEntityMap = resultEntityList.stream().collect(Collectors.toMap(MaterialResultEntity::getQuoteId, e -> e, (e1, e2) -> e1));
                    for (MaterialQuoteVO materialQuoteVO : materialQuoteVOS) {
                        AttachmentVO attachmentVO;
                        Long quoteVOId = materialQuoteVO.getId();
                        MaterialResultEntity materialResultEntity = resultEntityMap.get(quoteVOId);
                        if (materialResultEntity != null) {
                            materialQuoteVO.setBidFlag(materialResultEntity.getBidFlag());
                            materialQuoteVO.setBidMny(materialResultEntity.getBidMny());
                            materialQuoteVO.setBidMemo(materialResultEntity.getBidMemo());
                            sumBidMny = ComputeUtil.safeAdd((BigDecimal)sumBidMny, (BigDecimal)materialResultEntity.getBidMny());
                        } else {
                            materialQuoteVO.setBidFlag(Integer.valueOf(0));
                        }
                        if ((attachmentVO = (AttachmentVO)fileMap.get(quoteVOId)) == null) continue;
                        materialQuoteVO.setQuoteFileId(attachmentVO.getId());
                        materialQuoteVO.setQuoteFileName(attachmentVO.getFileName());
                    }
                    inquiryCommonVO.setSumBidMny((BigDecimal)sumBidMny);
                } else if (!fileMap.isEmpty()) {
                    for (MaterialQuoteVO quoteVO : materialQuoteVOS) {
                        AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(quoteVO.getId());
                        if (attachmentVO == null) continue;
                        quoteVO.setQuoteFileId(attachmentVO.getId());
                        quoteVO.setQuoteFileName(attachmentVO.getFileName());
                    }
                }
                Map<Long, List<MaterialQuoteVO>> supplierQuoteMap = materialQuoteVOS.stream().collect(Collectors.groupingBy(MaterialQuoteVO::getSupplierId));
                supplierNameMap = new HashMap<Long, String>();
                for (Long key : supplierQuoteMap.keySet()) {
                    List<MaterialQuoteVO> valueList = supplierQuoteMap.get(key);
                    if (valueList.size() > 1) {
                        int i = 1;
                        for (MaterialQuoteVO materialQuoteVO : valueList) {
                            materialQuoteVO.setSupplierName(materialQuoteVO.getSupplierName() + " (\u65b9\u6848" + i++ + ")");
                            supplierNameMap.put(materialQuoteVO.getId(), materialQuoteVO.getSupplierName());
                        }
                        continue;
                    }
                    supplierNameMap.put(valueList.get(0).getId(), valueList.get(0).getSupplierName());
                }
                if (inquiryCommonVO.getPricingType() != 1) break block17;
                LambdaQueryWrapper purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List purchaseDetailEntityList = this.materialQuotePurchaseDetailService.list((Wrapper)purchaseDetailEntityLambdaQueryWrapper);
                List materialQuotePurchaseDetailVOS = BeanMapper.mapList((Iterable)purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);
                if (!CollectionUtils.isNotEmpty((Collection)materialQuotePurchaseDetailVOS)) break block16;
                materialQuotePurchaseDetailVOS.forEach(t -> t.setSupplierName((String)supplierNameMap.get(t.getQuoteId())));
                Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));
                List materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();
                for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                    List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailList = purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(materialQuotePurchaseDetailList)) {
                        BigDecimal maxPrice = materialQuotePurchaseDetailList.stream().filter(t -> t.getPurchaseQuotePrice() != null).max(Comparator.comparing(MaterialQuotePurchaseDetailVO::getPurchaseQuotePrice)).get().getPurchaseQuotePrice();
                        BigDecimal minPrice = materialQuotePurchaseDetailList.stream().filter(t -> t.getPurchaseQuotePrice() != null).min(Comparator.comparing(MaterialQuotePurchaseDetailVO::getPurchaseQuotePrice)).get().getPurchaseQuotePrice();
                        materialInquiryPurchaseDetailVO.setMinBidPrice(minPrice);
                        materialInquiryPurchaseDetailVO.setMaxBidPrice(maxPrice);
                    }
                    materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(materialQuotePurchaseDetailList);
                }
                break block16;
            }
            LambdaQueryWrapper rentDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            rentDetailEntityLambdaQueryWrapper.in(MaterialQuoteRentDetailEntity::getQuoteId, quoteIds);
            List rentDetailEntityList = this.materialQuoteRentDetailService.list((Wrapper)rentDetailEntityLambdaQueryWrapper);
            List materialQuoteRentDetailVOS = BeanMapper.mapList((Iterable)rentDetailEntityList, MaterialQuoteRentDetailVO.class);
            if (CollectionUtils.isNotEmpty((Collection)materialQuoteRentDetailVOS)) {
                materialQuoteRentDetailVOS.forEach(t -> t.setSupplierName((String)supplierNameMap.get(t.getQuoteId())));
                Map<Long, List<MaterialQuoteRentDetailVO>> rentQuoteMap = materialQuoteRentDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuoteRentDetailVO::getSourceId));
                List materialInquiryRentDetailList = inquiryCommonVO.getMaterialInquiryRentDetailList();
                for (MaterialInquiryRentDetailVO materialInquiryRentDetailVO : materialInquiryRentDetailList) {
                    List<MaterialQuoteRentDetailVO> materialQuoteRentDetailVOList = rentQuoteMap.get(materialInquiryRentDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(materialQuoteRentDetailVOList)) {
                        BigDecimal maxPrice = materialQuoteRentDetailVOList.stream().filter(t -> t.getRentQuotePrice() != null).max(Comparator.comparing(MaterialQuoteRentDetailVO::getRentQuotePrice)).get().getRentQuotePrice();
                        BigDecimal minPrice = materialQuoteRentDetailVOList.stream().filter(t -> t.getRentQuotePrice() != null).min(Comparator.comparing(MaterialQuoteRentDetailVO::getRentQuotePrice)).get().getRentQuotePrice();
                        materialInquiryRentDetailVO.setMinBidPrice(minPrice);
                        materialInquiryRentDetailVO.setMaxBidPrice(maxPrice);
                    }
                    materialInquiryRentDetailVO.setMaterialQuoteRentDetailVOList(materialQuoteRentDetailVOList);
                }
            }
        }
        return inquiryCommonVO;
    }

    public JSONObject queryContractListByInquiry(Long inquiryId, Long picketageId, Integer inquiryState, String inquiryType) {
        CommonResponse resp;
        JSONObject resObj = new JSONObject();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(inquiryId != null, MaterialResultEntity::getInquiryId, (Object)inquiryId);
        wrapper.eq(picketageId != null, MaterialResultEntity::getPicketageId, (Object)picketageId);
        List list = this.materialResultService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resObj;
        }
        ArrayList<JSONObject> contractList = new ArrayList<JSONObject>();
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if ("material".equals(inquiryType)) {
            CommonResponse resp2 = this.materialContractApi.getContractByCondition(ids);
            if (resp2.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp2.getData()))) {
                for (MaterialContractVO materialContractVO : (List)resp2.getData()) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)materialContractVO.getId());
                    obj.put("billCode", (Object)materialContractVO.getCode());
                    obj.put("contractName", (Object)materialContractVO.getName());
                    obj.put("supplierName", (Object)materialContractVO.getSupplierName());
                    obj.put("contractType", (Object)"\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
                    obj.put("orgName", (Object)materialContractVO.getOrgName());
                    obj.put("contractMny", (Object)materialContractVO.getAmountWithTax());
                    obj.put("signDate", (Object)materialContractVO.getSignDate());
                    obj.put("billStateName", (Object)BillStateEnum.getEnumByStateCode((Integer)materialContractVO.getBillState()).getDescription());
                    contractList.add(obj);
                }
            }
        } else if ("rmat".equals(inquiryType) && (resp = this.rmatContractApi.getContractByCondition(ids)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            for (RentContractVO contractVO : (List)resp.getData()) {
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)contractVO.getId());
                obj.put("billCode", (Object)contractVO.getBillCode());
                obj.put("contractName", (Object)contractVO.getContractName());
                obj.put("supplierName", (Object)contractVO.getSupplierName());
                obj.put("contractType", (Object)"\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c");
                obj.put("orgName", (Object)contractVO.getOrgName());
                obj.put("contractMny", (Object)contractVO.getContractTaxMny());
                obj.put("signDate", (Object)contractVO.getSignDate());
                obj.put("billStateName", (Object)BillStateEnum.getEnumByStateCode((Integer)contractVO.getBillState()).getDescription());
                contractList.add(obj);
            }
        }
        resObj.put("contractList", contractList);
        return resObj;
    }
}

