/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketagePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageSupplierEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.PicketageQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.PicketageQuoteRentDetailEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialPicketageMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageSupplierService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.service.IPicketageQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IPicketageQuoteRentDetailService;
import com.ejianc.business.bidprice.material.service.InquiryCommonService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.bidprice.material.vo.MaterialPicketagePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.bidprice.material.vo.MaterialPriceVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialPicketageService")
public class MaterialPicketageServiceImpl
extends BaseServiceImpl<MaterialPicketageMapper, MaterialPicketageEntity>
implements IMaterialPicketageService {
    @Autowired
    private IMaterialPicketageSupplierService supplierService;
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IMaterialInquiryService inquiryService;
    @Autowired
    private IMaterialPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private IMaterialInquiryService materialInquiryService;
    @Autowired
    private InquiryCommonService inquiryCommonService;
    @Autowired
    private IPicketageQuotePurchaseDetailService purchaseDetailService;
    @Autowired
    private IPicketageQuoteRentDetailService rentDetailService;

    @Override
    public boolean insertOrUpdate(MaterialPicketageEntity entity) {
        Boolean success;
        ArrayList supplierEntities = new ArrayList();
        ArrayList supplierList = new ArrayList();
        if (!ListUtil.isEmpty(entity.getMaterialPicketageQuoteList())) {
            String bidWinnerIdStr = "";
            String bidWinnerNameStr = "";
            for (MaterialPicketageQuoteEntity quote : entity.getMaterialPicketageQuoteList()) {
                if (quote.getBidFlag() != 1) continue;
                bidWinnerIdStr = bidWinnerIdStr + quote.getSupplierId() + ",";
                bidWinnerNameStr = bidWinnerNameStr + quote.getSupplierName() + ",";
            }
            entity.setBidWinnerId(bidWinnerIdStr);
            entity.setBidWinnerName(bidWinnerNameStr);
        }
        if ((success = Boolean.valueOf(super.saveOrUpdate((Object)entity, false))).booleanValue()) {
            if (!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList())) {
                List suppliers;
                QueryParam param;
                List ids;
                entity.getMaterialPicketagePurchaseDetailList().forEach(sub -> supplierList.addAll(sub.getMaterialPicketageSupplierList()));
                if (entity.getPricingType() == 1) {
                    List<MaterialPicketagePurchaseDetailEntity> purchaseList = entity.getMaterialPicketagePurchaseDetailList();
                    ids = purchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(ids)) {
                        param = new QueryParam();
                        param.getParams().put("picketageDetailId", new Parameter("in", ids));
                        suppliers = this.supplierService.queryList(param, false);
                        if (!ListUtil.isEmpty((List)suppliers)) {
                            this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                        }
                        purchaseList.forEach(sub -> sub.getMaterialPicketageSupplierList().forEach(supplier -> {
                            supplier.setPicketageDetailId(sub.getId());
                            supplierEntities.add(supplier);
                        }));
                    }
                } else {
                    List<MaterialPicketageRentDetailEntity> rentList = entity.getMaterialPicketageRentDetailList();
                    ids = rentList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(ids)) {
                        param = new QueryParam();
                        param.getParams().put("picketageDetailId", new Parameter("in", ids));
                        suppliers = this.supplierService.queryList(param, false);
                        if (!ListUtil.isEmpty((List)suppliers)) {
                            this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                        }
                        rentList.forEach(sub -> sub.getMaterialPicketageSupplierList().forEach(supplier -> {
                            supplier.setPicketageDetailId(sub.getId());
                            supplierEntities.add(supplier);
                        }));
                    }
                }
                if (CollectionUtils.isNotEmpty(supplierEntities)) {
                    this.supplierService.saveOrUpdateBatch(supplierEntities, supplierEntities.size());
                }
            }
            if (CollectionUtils.isNotEmpty(entity.getMaterialPicketageQuoteList())) {
                ArrayList<PicketageQuotePurchaseDetailEntity> savePurchaseDetail = new ArrayList<PicketageQuotePurchaseDetailEntity>();
                ArrayList<PicketageQuoteRentDetailEntity> saveRentDetail = new ArrayList<PicketageQuoteRentDetailEntity>();
                List<MaterialPicketageQuoteEntity> quoteList = entity.getMaterialPicketageQuoteList();
                for (MaterialPicketageQuoteEntity quote : quoteList) {
                    if (CollectionUtils.isNotEmpty(quote.getPurchaseDetailList())) {
                        for (PicketageQuotePurchaseDetailEntity picketageQuotePurchaseDetailEntity : quote.getPurchaseDetailList()) {
                            picketageQuotePurchaseDetailEntity.setPicketageQuoteId(quote.getId());
                        }
                        savePurchaseDetail.addAll(quote.getPurchaseDetailList());
                    }
                    if (!CollectionUtils.isNotEmpty(quote.getRentDetailList())) continue;
                    for (PicketageQuoteRentDetailEntity picketageQuoteRentDetailEntity : quote.getRentDetailList()) {
                        picketageQuoteRentDetailEntity.setPicketageQuoteId(quote.getId());
                    }
                    saveRentDetail.addAll(quote.getRentDetailList());
                }
                if (CollectionUtils.isNotEmpty(savePurchaseDetail)) {
                    this.purchaseDetailService.saveOrUpdateBatch(savePurchaseDetail);
                }
                if (CollectionUtils.isNotEmpty(saveRentDetail)) {
                    this.rentDetailService.saveOrUpdateBatch(saveRentDetail);
                }
            }
        }
        return true;
    }

    @Override
    public void pushPicketage(Long billId) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)this.service.selectById(billId));
        if (entity.getSelfFlag() == 1) {
            MaterialResultEntity materialResultEntity = this.builderResultEntity(entity);
            this.materialResultService.saveOrUpdate((Object)materialResultEntity, false);
        } else {
            List<MaterialResultEntity> materialResultEntities = this.builderResultRef(entity);
            this.materialResultService.saveOrUpdateBatch(materialResultEntities);
        }
    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"picketage_id", (Object)billId);
        List list = this.materialResultService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.materialResultService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
    }

    public MaterialResultEntity builderResultEntity(MaterialPicketageEntity entity) {
        MaterialResultEntity result = new MaterialResultEntity();
        ArrayList<MaterialResultPurchaseDetailEntity> purchaseList = new ArrayList<MaterialResultPurchaseDetailEntity>();
        ArrayList<MaterialResultRentDetailEntity> rentList = new ArrayList<MaterialResultRentDetailEntity>();
        result.setPicketageId(entity.getId());
        if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        result.setPricingTypeName(entity.getPricingType() == 1 ? "\u91c7\u8d2d" : "\u79df\u8d41");
        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPricingType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
        result.setBillCode(entity.getBillCode());
        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketagePurchaseDetailList()) || CollectionUtils.isNotEmpty(entity.getMaterialPicketageRentDetailList())) {
            MaterialPicketageSupplierEntity materialPicketageSupplierEntity;
            Map<Object, Object> winSupplierMap = new HashMap();
            if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
                QueryParam param = new QueryParam();
                param.getParams().put("supplierId", new Parameter("eq", (Object)Long.parseLong(entity.getBidWinnerId())));
                List supplierEntities = this.supplierService.queryList(param, false);
                winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k -> k.getPicketageDetailId(), k -> k));
            }
            for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                MaterialResultPurchaseDetailEntity resultPurchase = new MaterialResultPurchaseDetailEntity();
                resultPurchase.setMaterialCategoryId(purchase.getMaterialCategoryId());
                resultPurchase.setMaterialCategoryName(purchase.getMaterialCategoryName());
                resultPurchase.setMaterialId(purchase.getMaterialId());
                resultPurchase.setMaterialName(purchase.getMaterialName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                if (!winSupplierMap.isEmpty()) {
                    materialPicketageSupplierEntity = (MaterialPicketageSupplierEntity)((Object)winSupplierMap.get(purchase.getId()));
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    resultPurchase.setBidMny(materialPicketageSupplierEntity.getMny());
                }
                purchaseList.add(resultPurchase);
            }
            for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                MaterialResultRentDetailEntity resultRent = new MaterialResultRentDetailEntity();
                resultRent.setMaterialCategoryId(rent.getMaterialCategoryId());
                resultRent.setMaterialCategoryName(rent.getMaterialCategoryName());
                resultRent.setMaterialId(rent.getMaterialId());
                resultRent.setMaterialName(rent.getMaterialName());
                resultRent.setSpec(rent.getSpec());
                resultRent.setUnit(rent.getUnit());
                resultRent.setResidueNum(rent.getNum());
                resultRent.setReferPrice(rent.getReferPrice());
                resultRent.setRentTerm(rent.getRentTerm());
                resultRent.setRentMode(rent.getRentMode());
                resultRent.setSourceId(rent.getId());
                if (!winSupplierMap.isEmpty()) {
                    materialPicketageSupplierEntity = (MaterialPicketageSupplierEntity)((Object)winSupplierMap.get(rent.getId()));
                    resultRent.setBidNum(rent.getNum());
                    resultRent.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    resultRent.setBidMny(materialPicketageSupplierEntity.getMny());
                }
                rentList.add(resultRent);
            }
        }
        if (CollectionUtils.isNotEmpty(rentList) || CollectionUtils.isNotEmpty(purchaseList)) {
            result.setMaterialResultRentDetailList(rentList);
            result.setMaterialResultPurchaseDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Object, Object> collect = new HashMap();
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.inquiryService.selectById((Serializable)((Object)inquiryId)));
        MaterialInquiryVO inquiryVO = (MaterialInquiryVO)BeanMapper.map((Object)((Object)materialInquiryEntity), MaterialInquiryVO.class);
        InquiryCommonVO inquiryCommonVO = this.inquiryCommonService.queryDetailByInquiry(materialInquiryEntity.getId(), materialInquiryEntity.getInquiryState(), materialInquiryEntity.getPricingType().toString());
        jsonObject.put("quoteList", (Object)inquiryCommonVO.getMaterialQuoteVOList());
        if (inquiryCommonVO.getPricingType().equals(new Integer(1))) {
            collect = inquiryCommonVO.getMaterialInquiryPurchaseDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryPurchaseDetailVO::getNum));
            jsonObject.put("materialInquiryPurchaseDetailList", (Object)inquiryCommonVO.getMaterialInquiryPurchaseDetailList());
        } else {
            collect = inquiryCommonVO.getMaterialInquiryRentDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryRentDetailVO::getNum));
            jsonObject.put("materialInquiryRentDetailList", (Object)inquiryCommonVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap", collect);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public JSONObject queryDetailToRef(Long id) {
        MaterialPicketageEntity picketageEntity = (MaterialPicketageEntity)((Object)this.service.selectById(id));
        Map<Object, Object> collect = new HashMap();
        MaterialInquiryEntity byId = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(picketageEntity.getInquiryId()));
        MaterialInquiryVO materialInquiry = (MaterialInquiryVO)BeanMapper.map((Object)((Object)byId), MaterialInquiryVO.class);
        collect = materialInquiry.getPricingType().equals(new Integer(1)) ? materialInquiry.getMaterialInquiryPurchaseDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryPurchaseDetailVO::getNum)) : materialInquiry.getMaterialInquiryRentDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryRentDetailVO::getNum));
        for (Object key : collect.keySet()) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"inquiry_id", (Object)picketageEntity.getInquiryId());
            ew.eq((Object)"source_id", key);
            ew.select(new String[]{"IFNULL(sum(bid_num),0) AS num"});
            Map map = this.purchaseDetailService.getMap((Wrapper)ew);
            BigDecimal num = ((BigDecimal)collect.get(key)).subtract((BigDecimal)map.get("num"));
            collect.put((Long)key, num);
        }
        for (MaterialPicketageQuoteEntity quote : picketageEntity.getMaterialPicketageQuoteList()) {
            if (quote.getBidFlag() != 1) continue;
            QueryWrapper quotePurchaseWrapper = new QueryWrapper();
            quotePurchaseWrapper.eq((Object)"picketage_quote_id", (Object)quote.getId());
            List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
                quote.setPurchaseDetailList(purchaseDetailEntities);
            }
            QueryWrapper quoteRentWrapper = new QueryWrapper();
            quoteRentWrapper.eq((Object)"picketage_quote_id", (Object)quote.getId());
            List rentDetailEntities = this.rentDetailService.list();
            if (!CollectionUtils.isNotEmpty((Collection)rentDetailEntities)) continue;
            quote.setRentDetailList(rentDetailEntities);
        }
        MaterialPicketageVO picketageVO = (MaterialPicketageVO)BeanMapper.map((Object)((Object)picketageEntity), MaterialPicketageVO.class);
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)picketageVO);
        InquiryCommonVO inquiryCommonVO = this.inquiryCommonService.queryDetailByInquiry(picketageEntity.getInquiryId(), materialInquiry.getInquiryState(), materialInquiry.getPricingType().toString());
        if (CollectionUtils.isNotEmpty((Collection)inquiryCommonVO.getMaterialInquiryPurchaseDetailList())) {
            jsonObject.put("picketagePurchaseDetailList", (Object)inquiryCommonVO.getMaterialInquiryPurchaseDetailList());
        }
        if (CollectionUtils.isNotEmpty((Collection)inquiryCommonVO.getMaterialInquiryRentDetailList())) {
            jsonObject.put("picketageRentDetailList", (Object)inquiryCommonVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap", collect);
        return jsonObject;
    }

    @Override
    public MaterialPicketageVO queryMaterialPicketageDetail(Long id) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)this.service.selectById(id));
        MaterialPicketageVO vo = new MaterialPicketageVO();
        entity = this.querySupplier(entity);
        vo = (MaterialPicketageVO)BeanMapper.map((Object)((Object)entity), MaterialPicketageVO.class);
        vo = this.service.queryMaterialPriceArea(vo);
        return vo;
    }

    private MaterialPicketageEntity querySupplier(MaterialPicketageEntity entity) {
        if (!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList())) {
            ArrayList detailIds = new ArrayList();
            List purchaseIds = entity.getMaterialPicketagePurchaseDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List rentIds = entity.getMaterialPicketageRentDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            detailIds.addAll(purchaseIds);
            detailIds.addAll(rentIds);
            Map<Object, Object> supplierMap = new HashMap();
            if (CollectionUtils.isNotEmpty(detailIds)) {
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId", new Parameter("in", detailIds));
                List supplierEntities = this.materialPicketageSupplierService.queryList(param, false);
                if (CollectionUtils.isNotEmpty((Collection)supplierEntities)) {
                    supplierMap = supplierEntities.stream().collect(Collectors.groupingBy(MaterialPicketageSupplierEntity::getPicketageDetailId));
                }
                if (!supplierMap.isEmpty()) {
                    for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                        rent.setMaterialPicketageSupplierList((List)supplierMap.get(rent.getId()));
                    }
                    for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                        purchase.setMaterialPicketageSupplierList((List)supplierMap.get(purchase.getId()));
                    }
                }
            }
        }
        return entity;
    }

    @Override
    public MaterialPicketageVO queryMaterialPriceArea(MaterialPicketageVO vo) {
        MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
        ArrayList<MaterialPriceVO> detail = new ArrayList<MaterialPriceVO>();
        List purchaseDetailList = vo.getMaterialPicketagePurchaseDetailList();
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailList)) {
            for (MaterialPicketagePurchaseDetailVO materialPicketagePurchaseDetailVO : purchaseDetailList) {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(materialPicketagePurchaseDetailVO.getMaterialId()));
                detail.add(materialPriceVO);
            }
        }
        if (CollectionUtils.isNotEmpty(detail)) {
            priceVO.setDetail(detail);
            MaterialPriceVO materialPriceVO = this.materialInquiryService.queryPrice(priceVO);
            List materialPriceVOS = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)materialPriceVOS)) {
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                List vos = vo.getMaterialPicketagePurchaseDetailList();
                if (CollectionUtils.isNotEmpty((Collection)vos)) {
                    for (MaterialPicketagePurchaseDetailVO materialPicketagePurchaseDetailVO : vos) {
                        Long materialId = materialPicketagePurchaseDetailVO.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (Objects.isNull(p)) continue;
                        materialPicketagePurchaseDetailVO.setMinPrice(p.getMinPrice());
                        materialPicketagePurchaseDetailVO.setMaxPrice(p.getMaxPrice());
                        materialPicketagePurchaseDetailVO.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                    }
                    vo.setMaterialPicketagePurchaseDetailList(vos);
                }
            }
        }
        return vo;
    }

    public List<MaterialResultEntity> builderResultRef(MaterialPicketageEntity entity) {
        ArrayList<MaterialResultEntity> resultList = new ArrayList<MaterialResultEntity>();
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketageQuoteList())) {
            List<MaterialPicketageQuoteEntity> quoteList = entity.getMaterialPicketageQuoteList();
            for (MaterialPicketageQuoteEntity quote : quoteList) {
                if (quote.getBidFlag() != 1) continue;
                MaterialResultEntity result = new MaterialResultEntity();
                result.setPicketageId(entity.getId());
                result.setProjectId(entity.getProjectId());
                result.setProjectName(entity.getProjectName());
                result.setOrgId(entity.getOrgId());
                result.setOrgName(entity.getOrgName());
                result.setPurchaseSubject(entity.getName());
                result.setPricingType(entity.getPricingType());
                result.setPricingTypeName(entity.getPricingType() == 1 ? "\u91c7\u8d2d" : "\u79df\u8d41");
                result.setPurchaseType(entity.getPurchaseType());
                result.setPurchaseTypeName(entity.getPricingType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
                result.setBillCode(entity.getBillCode());
                result.setInquiryMny(entity.getInquiryMny());
                result.setBidFlag(1);
                result.setHandleDate(entity.getHandleDate());
                result.setBidMny(quote.getBidMny());
                result.setSupplierId(quote.getSupplierId());
                result.setSupplierName(quote.getSupplierName());
                result.setSocialCreditCode(quote.getSocialCreditCode());
                if (entity.getPricingType() == 1) {
                    if (CollectionUtils.isNotEmpty(quote.getPurchaseDetailList())) {
                        List<PicketageQuotePurchaseDetailEntity> purchaseDetailList = quote.getPurchaseDetailList();
                        ArrayList<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetail = new ArrayList<MaterialResultPurchaseDetailEntity>();
                        for (PicketageQuotePurchaseDetailEntity purchase : purchaseDetailList) {
                            MaterialResultPurchaseDetailEntity purchaseDetail = new MaterialResultPurchaseDetailEntity();
                            purchaseDetail.setSourceId(purchase.getId());
                            purchaseDetail.setMaterialCategoryId(purchase.getMaterialCategoryId());
                            purchaseDetail.setMaterialCategoryName(purchase.getMaterialCategoryName());
                            purchaseDetail.setMaterialId(purchase.getMaterialId());
                            purchaseDetail.setMaterialName(purchase.getMaterialName());
                            purchaseDetail.setSpec(purchase.getSpec());
                            purchaseDetail.setUnit(purchase.getUnit());
                            purchaseDetail.setResidueNum(purchase.getResidueNum());
                            purchaseDetail.setReferPrice(purchase.getReferPrice());
                            purchaseDetail.setBidNum(purchase.getBidNum());
                            purchaseDetail.setBidPrice(purchase.getBidPrice());
                            purchaseDetail.setBidMny(purchase.getBidMny());
                            materialResultPurchaseDetail.add(purchaseDetail);
                        }
                        result.setMaterialResultPurchaseDetailList(materialResultPurchaseDetail);
                    }
                } else if (CollectionUtils.isNotEmpty(quote.getRentDetailList())) {
                    List<PicketageQuoteRentDetailEntity> rentDetailList = quote.getRentDetailList();
                    ArrayList<MaterialResultRentDetailEntity> rentDetailEntities = new ArrayList<MaterialResultRentDetailEntity>();
                    for (PicketageQuoteRentDetailEntity rent : rentDetailList) {
                        MaterialResultRentDetailEntity rentDetailEntity = new MaterialResultRentDetailEntity();
                        rentDetailEntity.setSourceId(rent.getId());
                        rentDetailEntity.setMaterialCategoryId(rent.getMaterialCategoryId());
                        rentDetailEntity.setMaterialCategoryName(rent.getMaterialCategoryName());
                        rentDetailEntity.setMaterialId(rent.getMaterialId());
                        rentDetailEntity.setMaterialName(rent.getMaterialName());
                        rentDetailEntity.setSpec(rent.getSpec());
                        rentDetailEntity.setUnit(rent.getUnit());
                        rentDetailEntity.setResidueNum(rent.getResidueNum());
                        rentDetailEntity.setReferPrice(rent.getReferPrice());
                        rentDetailEntity.setBidNum(rent.getBidNum());
                        rentDetailEntity.setBidPrice(rent.getBidPrice());
                        rentDetailEntity.setBidMny(rent.getBidMny());
                        rentDetailEntity.setRentTerm(rent.getRentTerm());
                        rentDetailEntity.setRentMode(rent.getRentMode());
                        rentDetailEntities.add(rentDetailEntity);
                    }
                    result.setMaterialResultRentDetailList(rentDetailEntities);
                }
                resultList.add(result);
            }
        }
        return resultList;
    }
}

