/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.impl.MaterialPicketageServiceImpl;
import com.ejianc.business.bidprice.material.utils.ArchivesUtil;
import com.ejianc.business.bidprice.material.vo.ImportMaterialInquiryDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialInquiry"})
@Api(value="\u6750\u6599\u8be2\u4ef7", tags={"\u6750\u6599\u8be2\u4ef7"})
public class MaterialInquiryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MATERIAL_INQUIRY";
    @Autowired
    private IMaterialInquiryService service;
    @Autowired
    private MaterialPicketageServiceImpl materialPicketageService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;
    @Autowired
    private IMaterialSettlementApi materialSettlementApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialInquiryVO saveOrUpdateVO) {
        List list;
        String sourceList;
        JSONObject jsonObject;
        String onlykey;
        MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialInquiryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getMaterialInquiryPurchaseDetailList())) {
            List purchaseDetailList = saveOrUpdateVO.getMaterialInquiryPurchaseDetailList();
            for (MaterialInquiryPurchaseDetailVO detailVO : purchaseDetailList) {
                onlykey = detailVO.getMaterialCategoryName() + detailVO.getMaterialName() + detailVO.getUnit() + detailVO.getSpec();
                detailVO.setOnlyKey(onlykey);
            }
            jsonObject = this.archivesUtil.batchSaveArchive(purchaseDetailList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "unit", "spec", "errorMessage");
            sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            list = JSONObject.parseArray((String)sourceList, MaterialInquiryPurchaseDetailVO.class);
            List purchaseDetailEntities = BeanMapper.mapList((Iterable)list, MaterialInquiryPurchaseDetailEntity.class);
            entity.setMaterialInquiryPurchaseDetailList(purchaseDetailEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getMaterialInquiryRentDetailList())) {
            List rentDetailList = saveOrUpdateVO.getMaterialInquiryRentDetailList();
            for (MaterialInquiryPurchaseDetailVO detailVO : rentDetailList) {
                onlykey = detailVO.getMaterialCategoryName() + detailVO.getMaterialName() + detailVO.getUnit() + detailVO.getSpec();
                detailVO.setOnlyKey(onlykey);
            }
            jsonObject = this.archivesUtil.batchSaveArchive(rentDetailList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "unit", "spec", "errorMessage");
            sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            list = JSONObject.parseArray((String)sourceList, MaterialInquiryRentDetailVO.class);
            List rentDetailEntities = BeanMapper.mapList((Iterable)list, MaterialInquiryRentDetailEntity.class);
            entity.setMaterialInquiryRentDetailList(rentDetailEntities);
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialInquiryVO vo = (MaterialInquiryVO)BeanMapper.map((Object)((Object)entity), MaterialInquiryVO.class);
        vo = this.service.queryMaterialPrice(vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateInquiry"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> updateInquiry(@RequestBody MaterialInquiryVO updateVo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MaterialPicketageEntity::getInquiryId, (Object)updateVo.getId());
        List list = this.materialPicketageService.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            return CommonResponse.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5df2\u5b9a\u6807\uff01");
        }
        MaterialInquiryVO vo = this.service.updateInquiry(updateVo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> queryDetail(@RequestParam Long id) {
        MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728\uff01", null);
        }
        MaterialInquiryVO vo = (MaterialInquiryVO)BeanMapper.map((Object)((Object)entity), MaterialInquiryVO.class);
        vo = this.service.queryMaterialPrice(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"queryPrice"})
    @ResponseBody
    public CommonResponse<List<MaterialPriceVO>> queryPrice(@RequestBody MaterialPriceVO vo) {
        CommonResponse commonResponse = this.materialSettlementApi.queryPrice(vo);
        if (commonResponse.isSuccess()) {
            MaterialPriceVO materialPriceVO = (MaterialPriceVO)commonResponse.getData();
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)materialPriceVO.getDetail());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialInquiryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialInquiryVO materialInquiryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("inquiryState")) {
            Integer inquiryState = Integer.parseInt(((Parameter)param.getParams().get("inquiryState")).getValue().toString());
            if (InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("gt", (Object)new Date()));
            }
            if (InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode((Integer)vo.getInquiryState()));
            if (InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0) {
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            if (!InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) || vo.getQuoteEndDate().compareTo(new Date()) <= 0) continue;
            vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
        }
        pageData.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("inquiryState")) {
            Integer inquiryState = Integer.parseInt(((Parameter)param.getParams().get("inquiryState")).getValue().toString());
            if (InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("gt", (Object)new Date()));
            }
            if (InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
            }
        }
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode((Integer)vo.getInquiryState()));
            if (InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0) {
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            if (!InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) || vo.getQuoteEndDate().compareTo(new Date()) <= 0) continue;
            vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("MaterialInquiry-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        List<ImportMaterialInquiryDetailVO> successList = new ArrayList();
        ArrayList<ImportMaterialInquiryDetailVO> errorList = new ArrayList<ImportMaterialInquiryDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ImportMaterialInquiryDetailVO useApplySubVO = new ImportMaterialInquiryDetailVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    useApplySubVO.setErrorMessage("\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else {
                    useApplySubVO.setMaterialCategoryName(((String)datas.get(0)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    useApplySubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 20) {
                    useApplySubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    useApplySubVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    useApplySubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 200) {
                    useApplySubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    useApplySubVO.setSpec(((String)datas.get(2)).trim());
                }
                if (StringUtils.isNotEmpty((String)((String)datas.get(3)))) {
                    useApplySubVO.setUnit(((String)datas.get(3)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) && ((String)datas.get(8)).length() > 50) {
                    useApplySubVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    useApplySubVO.setMemo((String)datas.get(8));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    try {
                        useApplySubVO.setNum(new BigDecimal((String)datas.get(4)));
                        if (useApplySubVO.getNum().longValue() < 0L) {
                            useApplySubVO.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        useApplySubVO.setReferPrice(new BigDecimal((String)datas.get(5)));
                        if (useApplySubVO.getReferPrice().doubleValue() < 0.0) {
                            useApplySubVO.setErrorMessage("\u53c2\u8003\u4ef7\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u53c2\u8003\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    useApplySubVO.setReferPrice(new BigDecimal(0));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        useApplySubVO.setMny(new BigDecimal((String)datas.get(6)));
                        if (useApplySubVO.getMny().doubleValue() < 0.0) {
                            useApplySubVO.setErrorMessage("\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    useApplySubVO.setMny(new BigDecimal(0));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                        String time = (String)datas.get(7);
                        Date date = ft.parse(time);
                        useApplySubVO.setPlanUseDate(date);
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u8ba1\u5212\u8fdb\u573a\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c\u4f8b\u59822022-01-01");
                    }
                }
                if (StringUtils.isNotEmpty((String)useApplySubVO.getErrorMessage())) {
                    errorList.add(useApplySubVO);
                    continue;
                }
                String onlykey = useApplySubVO.getMaterialCategoryName() + useApplySubVO.getMaterialName() + useApplySubVO.getUnit() + useApplySubVO.getSpec();
                useApplySubVO.setOnlyKey(onlykey);
                successList.add(useApplySubVO);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            JSONObject match = this.archivesUtil.findMatch(successList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "unit", "model", "errorMessage");
            successList = (List)match.get((Object)"sourceList");
            List errorList1 = (List)match.get((Object)"errorList");
            errorList.addAll(errorList1);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialInquiryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> refMaterialInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List fuzzyFields;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchObject(searchObject);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("purchaseSubject");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            fuzzyFields = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
        param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode((Integer)vo.getInquiryState()));
        }
        pageData.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

