package com.ejianc.business.bidprice.material.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.*;
import com.ejianc.business.bidprice.material.service.impl.MaterialPicketageServiceImpl;
import com.ejianc.business.bidprice.material.utils.ArchivesUtil;
import com.ejianc.business.bidprice.material.vo.*;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 材料询价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialInquiry")
@Api(value = "材料询价", tags = {"材料询价"})
public class MaterialInquiryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MATERIAL_INQUIRY";//此处需要根据实际修改

    @Autowired
    private IMaterialInquiryService service;

    @Autowired
    private MaterialPicketageServiceImpl materialPicketageService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ArchivesUtil archivesUtil;

    @Autowired
    private IMaterialSettlementApi materialSettlementApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialInquiryVO saveOrUpdateVO) {
    	MaterialInquiryEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialInquiryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getMaterialInquiryPurchaseDetailList())){

            List<MaterialInquiryPurchaseDetailVO> purchaseDetailList = saveOrUpdateVO.getMaterialInquiryPurchaseDetailList();
            for (MaterialInquiryPurchaseDetailVO detailVO : purchaseDetailList) {
                String onlykey= detailVO.getMaterialCategoryName()+detailVO.getMaterialName()+detailVO.getUnit()+detailVO.getSpec();
                detailVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = archivesUtil.batchSaveArchive(purchaseDetailList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<MaterialInquiryPurchaseDetailVO> list = JSONObject.parseArray(sourceList, MaterialInquiryPurchaseDetailVO.class);
            List<MaterialInquiryPurchaseDetailEntity> purchaseDetailEntities = BeanMapper.mapList(list, MaterialInquiryPurchaseDetailEntity.class);
            entity.setMaterialInquiryPurchaseDetailList(purchaseDetailEntities);
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getMaterialInquiryRentDetailList())){

            List<MaterialInquiryRentDetailVO> rentDetailList = saveOrUpdateVO.getMaterialInquiryRentDetailList();
            for (MaterialInquiryRentDetailVO detailVO : rentDetailList) {
                String onlykey= detailVO.getMaterialCategoryName()+detailVO.getMaterialName()+detailVO.getUnit()+detailVO.getSpec();
                detailVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = archivesUtil.batchSaveArchive(rentDetailList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<MaterialInquiryRentDetailVO> list = JSONObject.parseArray(sourceList, MaterialInquiryRentDetailVO.class);
            List<MaterialInquiryRentDetailEntity> rentDetailEntities = BeanMapper.mapList(list, MaterialInquiryRentDetailEntity.class);
            entity.setMaterialInquiryRentDetailList(rentDetailEntities);
        }
    	service.saveOrUpdate(entity, false);
    	MaterialInquiryVO vo = BeanMapper.map(entity, MaterialInquiryVO.class);
        //计算历史价接口
        vo = service.queryMaterialPrice(vo);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 截止报价，修改供应商
     * @param updateVo
     * @return
     */
    @RequestMapping(value = "/updateInquiry", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> updateInquiry(@RequestBody MaterialInquiryVO updateVo){
        LambdaQueryWrapper<MaterialPicketageEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialPicketageEntity::getInquiryId,updateVo.getId());
        List<MaterialPicketageEntity> list = materialPicketageService.list(queryWrapper);
        if(list.size()>0){
            return CommonResponse.error("修改失败，当前单据已定标！");
        }

        MaterialInquiryVO vo = service.updateInquiry(updateVo);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> queryDetail(@RequestParam Long id) {
    	MaterialInquiryEntity entity = service.selectById(id);
    	if(entity == null){
    	    return CommonResponse.error("查询详情失败，数据不存在！",null);
        }
    	MaterialInquiryVO vo = BeanMapper.map(entity, MaterialInquiryVO.class);
        //计算历史价接口
        vo = service.queryMaterialPrice(vo);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询历史价，参照新增时使用
     * @param vo
     * @return
     */
    @PostMapping("queryPrice")
    @ResponseBody
    public CommonResponse<List<MaterialPriceVO>> queryPrice(@RequestBody MaterialPriceVO vo) {
        //service.queryPrice(vo);
        CommonResponse<MaterialPriceVO> commonResponse = materialSettlementApi.queryPrice(vo);
        if(commonResponse.isSuccess()){
            MaterialPriceVO materialPriceVO = commonResponse.getData();
            return CommonResponse.success("查询成功！", materialPriceVO.getDetail());
        }else{
            return CommonResponse.error("查询失败！");
        }
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialInquiryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialInquiryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialInquiryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //筛选条件为报价中时，同时查询报价中、已截止但还未到截止报价时间的
            if(InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.GT,new Date()));
            }
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
        }

        IPage<MaterialInquiryEntity> page = service.queryPage(param,false);
        IPage<MaterialInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialInquiryVO> vos = BeanMapper.mapList(page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
            //报价中但已超时的询价申请，需要显示为已截止
            if(InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0){
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            //已截止并且截止时间大于当前时间，显示为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) > 0){
                vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
            }
        }
        pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //筛选条件为报价中时，同时查询报价中、已截止但还未到截止报价时间的
            if(InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.GT,new Date()));
            }
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
        }
        List<MaterialInquiryEntity> list = service.queryList(param);
        List<MaterialInquiryVO> vos = BeanMapper.mapList(list, MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
            //报价中但已超时的询价申请，需要显示为已截止
            if(InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0){
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            //已截止并且截止时间大于当前时间，显示为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) > 0){
                vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("MaterialInquiry-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportMaterialInquiryDetailVO> successList = new ArrayList<>();
            List<ImportMaterialInquiryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 9) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ImportMaterialInquiryDetailVO useApplySubVO = new ImportMaterialInquiryDetailVO();
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(0))) {
                        useApplySubVO.setErrorMessage("物资分类名称为必填项");
                    }  else {
                        useApplySubVO.setMaterialCategoryName(datas.get(0).trim());
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(1))) {
                        useApplySubVO.setErrorMessage("物资名称为必填项");
                    } else if (datas.get(1).length() > 20) {
                        useApplySubVO.setErrorMessage("物资名称填写长度为0~20字");
                    } else {
                        useApplySubVO.setMaterialName(datas.get(1).trim());
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(2))) {
                        useApplySubVO.setErrorMessage("规格型号为必填项");
                    } else if (datas.get(2).length() > 200) {
                        useApplySubVO.setErrorMessage("规格型号填写长度为0~200字");
                    } else {
                        useApplySubVO.setSpec(datas.get(2).trim());
                    }
                    if (org.apache.commons.lang.StringUtils.isNotEmpty(datas.get(3))){
                        useApplySubVO.setUnit(datas.get(3).trim());
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(8)) && datas.get(8).length() > 50) {
                        useApplySubVO.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        useApplySubVO.setMemo(datas.get(8));
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(4))) {
                        try {
                            useApplySubVO.setNum(new BigDecimal(datas.get(4)));
                            if (useApplySubVO.getNum().longValue() < 0) {
                                useApplySubVO.setErrorMessage("数量必须大于0");
                            }
                        } catch (Exception e) {
                            useApplySubVO.setErrorMessage("数量必须为数字");
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            useApplySubVO.setReferPrice(new BigDecimal(datas.get(5)));
                            if (useApplySubVO.getReferPrice().doubleValue() < 0) {
                                useApplySubVO.setErrorMessage("参考价必须大于0");
                            }
                        } catch (Exception e) {
                            useApplySubVO.setErrorMessage("参考价必须为数字");
                        }
                    } else {
                        useApplySubVO.setReferPrice(new BigDecimal(0));
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            useApplySubVO.setMny(new BigDecimal(datas.get(6)));
                            if (useApplySubVO.getMny().doubleValue() < 0) {
                                useApplySubVO.setErrorMessage("金额必须大于0");
                            }
                        } catch (Exception e) {
                            useApplySubVO.setErrorMessage("金额必须为数字");
                        }
                    } else {
                        useApplySubVO.setMny(new BigDecimal(0));
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                            String time = datas.get(7);
                            Date date = ft.parse(time);
                            useApplySubVO.setPlanUseDate(date);
                        } catch (Exception e) {
                            useApplySubVO.setErrorMessage("计划进场日期格式有误，例如2022-01-01");
                        }
                    }
                    if (org.apache.commons.lang.StringUtils.isNotEmpty(useApplySubVO.getErrorMessage())) {
                        errorList.add(useApplySubVO);
                    } else {
                        String onlykey= useApplySubVO.getMaterialCategoryName()+useApplySubVO.getMaterialName()+useApplySubVO.getUnit()+useApplySubVO.getSpec();
                        useApplySubVO.setOnlyKey(onlykey);
                        successList.add(useApplySubVO);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(successList)){
                JSONObject match = archivesUtil.findMatch(successList, "materialCategoryId", "materialId",
                        "materialCategoryName", "materialName", "unit", "model", "errorMessage");
                successList= (List<ImportMaterialInquiryDetailVO>)match.get("sourceList");
                List<ImportMaterialInquiryDetailVO> errorList1 = (List<ImportMaterialInquiryDetailVO>)match.get("errorList");
                errorList.addAll(errorList1);
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialInquiryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> refMaterialInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("purchaseSubject");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
        param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage<MaterialInquiryEntity> page = service.queryPage(param,false);
        IPage<MaterialInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialInquiryVO> vos = BeanMapper.mapList(page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
        }
        pageData.setRecords(vos);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

}
