package com.ejianc.business.bidprice.material.service;

import cn.hutool.core.date.DateUnit;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.consts.InquiryTypeConsts;
import com.ejianc.business.bidprice.material.bean.*;
import com.ejianc.business.bidprice.material.vo.*;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 询价公共服务
 * @author songlx
 * @date 2023/2/8
 * @version 1.0
 */

@Service("inquiryCommonService")
public class InquiryCommonService {

    @Autowired
    private IMaterialInquiryService materialInquiryService;

    @Autowired
    private IMaterialQuoteService materialQuoteService;


    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;

    @Autowired
    private IMaterialQuoteRentDetailService materialQuoteRentDetailService;

    @Autowired
    private IMaterialContractApi materialContractApi;

    @Autowired
    private IRmatContractApi rmatContractApi;

    @Autowired
    private IMaterialResultService materialResultService;

    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * @description: 查询各个阶段的询价详情
     *
     * @param inquiryId
     * @param inquiryState
     * @param inquiryType
     * @return {@link InquiryCommonVO}
     * @author songlx
     * @date: 2023/2/8
     */
    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        MaterialInquiryEntity inquiryEntity = materialInquiryService.selectById(inquiryId);
        MaterialInquiryVO materialInquiryVO = BeanMapper.map(inquiryEntity, MaterialInquiryVO.class);
        materialInquiryService.queryMaterialPrice(materialInquiryVO);

        InquiryCommonVO inquiryCommonVO = BeanMapper.map(materialInquiryVO, InquiryCommonVO.class);

        LambdaQueryWrapper<MaterialQuoteEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialQuoteEntity::getInquiryId, inquiryId);
        queryWrapper.in(MaterialQuoteEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<MaterialQuoteEntity> list = materialQuoteService.list(queryWrapper);
        List<MaterialQuoteVO> materialQuoteVOS = BeanMapper.mapList(list, MaterialQuoteVO.class);
        inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
        if (CollectionUtils.isNotEmpty(materialQuoteVOS)) {
            List<Long> quoteIds = materialQuoteVOS.stream().map(MaterialQuoteVO::getId).collect(Collectors.toList());

            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add("quote");
            fileParam.put("sourceTypeList", JSONObject.toJSONString(sourceTypeArr));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(fileParam);
            List<AttachmentVO> fileData = listCommonResponse.getData();
            Map<Long, AttachmentVO> fileMap = new HashMap<>();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }

            LambdaQueryWrapper<MaterialResultEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(MaterialResultEntity::getQuoteId, quoteIds);
            List<MaterialResultEntity> resultEntityList = materialResultService.list(wrapper);
            if (CollectionUtils.isNotEmpty(resultEntityList)) {
                BigDecimal sumBidMny = BigDecimal.ZERO;
                Map<Long, MaterialResultEntity> resultEntityMap = resultEntityList.stream().collect(Collectors.toMap(MaterialResultEntity::getQuoteId, e -> e, (e1, e2) -> e1));

                for (MaterialQuoteVO materialQuoteVO : materialQuoteVOS) {
                    Long quoteVOId = materialQuoteVO.getId();
                    MaterialResultEntity materialResultEntity = resultEntityMap.get(quoteVOId);
                    if (materialResultEntity != null) {
                        materialQuoteVO.setSupplierName(materialResultEntity.getSupplierName());
                        materialQuoteVO.setBidFlag(materialResultEntity.getBidFlag());
                        materialQuoteVO.setBidMny(materialResultEntity.getBidMny());
                        materialQuoteVO.setBidMemo(materialResultEntity.getBidMemo());
                        sumBidMny = ComputeUtil.safeAdd(sumBidMny, materialResultEntity.getBidMny());
                    } else {
                        materialQuoteVO.setBidFlag(0);
                    }
                    AttachmentVO attachmentVO = fileMap.get(quoteVOId);
                    if (attachmentVO != null) {
                        materialQuoteVO.setQuoteFileId(attachmentVO.getId());
                        materialQuoteVO.setQuoteFileName(attachmentVO.getFileName());
                    }

                }
                inquiryCommonVO.setSumBidMny(sumBidMny);
            } else {
                if (!fileMap.isEmpty()) {
                    for (MaterialQuoteVO quoteVO : materialQuoteVOS) {
                        AttachmentVO attachmentVO = fileMap.get(quoteVO.getId());
                        if (attachmentVO != null) {
                            quoteVO.setQuoteFileId(attachmentVO.getId());
                            quoteVO.setQuoteFileName(attachmentVO.getFileName());
                        }
                    }
                }
            }

            Map<String, List<MaterialQuoteVO>> supplierQuoteMap = materialQuoteVOS.stream().collect(Collectors.groupingBy(MaterialQuoteVO::getSupplierName));

            HashMap<Long, String> supplierNameMap = new HashMap<>();
            for (String key : supplierQuoteMap.keySet()) {
                List<MaterialQuoteVO> valueList = supplierQuoteMap.get(key);
                if (valueList.size() > 1) {
                    int i = 1;
                    for (MaterialQuoteVO materialQuoteVO : valueList) {
                        materialQuoteVO.setSupplierName(materialQuoteVO.getSupplierName() + " (方案" + i++ + ")");
                        supplierNameMap.put(materialQuoteVO.getId(), materialQuoteVO.getSupplierName());
                    }
                } else {
                    supplierNameMap.put(valueList.get(0).getId(), valueList.get(0).getSupplierName());
                }
            }

            //List<Long> quoteIds = new ArrayList<>(supplierNameMap.keySet());
            //采购
            if (inquiryCommonVO.getPricingType() == 1) {
                LambdaQueryWrapper<MaterialQuotePurchaseDetailEntity> purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List<MaterialQuotePurchaseDetailEntity> purchaseDetailEntityList = materialQuotePurchaseDetailService.list(purchaseDetailEntityLambdaQueryWrapper);
                List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailVOS = BeanMapper.mapList(purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);

                if (CollectionUtils.isNotEmpty(materialQuotePurchaseDetailVOS)) {
                    materialQuotePurchaseDetailVOS.forEach(t -> t.setSupplierName(supplierNameMap.get(t.getQuoteId())));
                    Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));

                    List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();

                    for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                        List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailList = purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId());
                        if (CollectionUtils.isNotEmpty(materialQuotePurchaseDetailList)) {
                            BigDecimal maxPrice = materialQuotePurchaseDetailList.stream().filter(t -> t.getPurchaseQuotePrice() != null).max(Comparator.comparing(MaterialQuotePurchaseDetailVO::getPurchaseQuotePrice)).get().getPurchaseQuotePrice();
                            BigDecimal minPrice = materialQuotePurchaseDetailList.stream().filter(t -> t.getPurchaseQuotePrice() != null).min(Comparator.comparing(MaterialQuotePurchaseDetailVO::getPurchaseQuotePrice)).get().getPurchaseQuotePrice();
                            materialInquiryPurchaseDetailVO.setMinBidPrice(minPrice);
                            materialInquiryPurchaseDetailVO.setMaxBidPrice(maxPrice);
                        }

                        materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(materialQuotePurchaseDetailList);
                    }
                }


                //租赁
            } else {
                LambdaQueryWrapper<MaterialQuoteRentDetailEntity> rentDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                rentDetailEntityLambdaQueryWrapper.in(MaterialQuoteRentDetailEntity::getQuoteId, quoteIds);
                List<MaterialQuoteRentDetailEntity> rentDetailEntityList = materialQuoteRentDetailService.list(rentDetailEntityLambdaQueryWrapper);
                List<MaterialQuoteRentDetailVO> materialQuoteRentDetailVOS = BeanMapper.mapList(rentDetailEntityList, MaterialQuoteRentDetailVO.class);

                if (CollectionUtils.isNotEmpty(materialQuoteRentDetailVOS)) {
                    materialQuoteRentDetailVOS.forEach(t -> t.setSupplierName(supplierNameMap.get(t.getQuoteId())));
                    Map<Long, List<MaterialQuoteRentDetailVO>> rentQuoteMap = materialQuoteRentDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuoteRentDetailVO::getSourceId));

                    List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList = inquiryCommonVO.getMaterialInquiryRentDetailList();

                    for (MaterialInquiryRentDetailVO materialInquiryRentDetailVO : materialInquiryRentDetailList) {
                        List<MaterialQuoteRentDetailVO> materialQuoteRentDetailVOList = rentQuoteMap.get(materialInquiryRentDetailVO.getId());
                        if (CollectionUtils.isNotEmpty(materialQuoteRentDetailVOList)) {
                            BigDecimal maxPrice = materialQuoteRentDetailVOList.stream().filter(t -> t.getRentQuotePrice() != null).max(Comparator.comparing(MaterialQuoteRentDetailVO::getRentQuotePrice)).get().getRentQuotePrice();
                            BigDecimal minPrice = materialQuoteRentDetailVOList.stream().filter(t -> t.getRentQuotePrice() != null).min(Comparator.comparing(MaterialQuoteRentDetailVO::getRentQuotePrice)).get().getRentQuotePrice();
                            materialInquiryRentDetailVO.setMinBidPrice(minPrice);
                            materialInquiryRentDetailVO.setMaxBidPrice(maxPrice);
                        }
                        materialInquiryRentDetailVO.setMaterialQuoteRentDetailVOList(materialQuoteRentDetailVOList);
                    }
                }

            }

        }

        return inquiryCommonVO;
    }

    public JSONObject queryContractListByInquiry(Long inquiryId, Long picketageId, Integer inquiryState, String inquiryType) {
        JSONObject resObj = new JSONObject();
        LambdaQueryWrapper<MaterialResultEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(inquiryId != null, MaterialResultEntity::getInquiryId, inquiryId);
        wrapper.eq(picketageId != null, MaterialResultEntity::getPicketageId, picketageId);
        List<MaterialResultEntity> list = materialResultService.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return resObj;
        }

        List<JSONObject> contractList = new ArrayList<>();
        List<Long> ids = list.stream().map(MaterialResultEntity::getId).collect(Collectors.toList());
        if (InquiryTypeConsts.MATERIAL.equals(inquiryType)) {
            CommonResponse<List<MaterialContractVO>> resp = materialContractApi.getContractByCondition(ids);
            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
                for (MaterialContractVO materialContractVO : resp.getData()) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", materialContractVO.getId());
                    obj.put("code", materialContractVO.getCode());
                    obj.put("contractName", materialContractVO.getName());
                    obj.put("supplierName", materialContractVO.getSupplierName());
                    obj.put("contractType", "物资采购合同");
                    obj.put("orgName", materialContractVO.getOrgName());
                    obj.put("contractMny", materialContractVO.getAmountWithTax());
                    if (materialContractVO.getSignDate()!=null){
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        String signDate = format.format(materialContractVO.getSignDate());
                        obj.put("signDate",signDate);
                    }
                    obj.put("billStateName", BillStateEnum.getEnumByStateCode(materialContractVO.getBillState()).getDescription());
                    contractList.add(obj);
                }
            }
        } else if (InquiryTypeConsts.RMAT.equals(inquiryType)) {
            CommonResponse<List<RentContractVO>> resp = rmatContractApi.getContractByCondition(ids);
            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
                for (RentContractVO contractVO : resp.getData()) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", contractVO.getId());
                    obj.put("code", contractVO.getBillCode());
                    obj.put("contractName", contractVO.getContractName());
                    obj.put("supplierName", contractVO.getSupplierName());
                    obj.put("contractType", "周转材租赁合同");
                    obj.put("orgName", contractVO.getOrgName());
                    obj.put("contractMny", contractVO.getContractTaxMny());
                    if (contractVO.getSignDate()!=null){
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        String signDate = format.format(contractVO.getSignDate());
                        obj.put("signDate",signDate);
                    }
                    obj.put("billStateName", BillStateEnum.getEnumByStateCode(contractVO.getBillState()).getDescription());
                    contractList.add(obj);
                }
            }
        }
        resObj.put("contractList", contractList);
        return resObj;
    }
}
