/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.service.IMaterialResultPurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialResultRentDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.bidprice.material.vo.MaterialResultPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialResultRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialResult"})
@Api(value="\u6750\u6599\u5b9a\u6807\u7ed3\u679c", tags={"\u6750\u6599\u5b9a\u6807\u7ed3\u679c"})
public class MaterialResultController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MATERIAL_RESULT";
    @Autowired
    private IMaterialResultService service;
    @Autowired
    private IMaterialResultPurchaseDetailService materialResultPurchaseDetailService;
    @Autowired
    private IMaterialResultRentDetailService materialResultRentDetailService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialResultVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialResultVO saveOrUpdateVO) {
        MaterialResultEntity entity = (MaterialResultEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialResultEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialResultVO vo = (MaterialResultVO)BeanMapper.map((Object)((Object)entity), MaterialResultVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e2d\u6807\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialResultVO>> querySupplierList(@RequestParam Long picketageId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialResultEntity::getPicketageId, (Object)picketageId);
        List list = this.service.list((Wrapper)wrapper);
        List materialResultVOS = BeanMapper.mapList((Iterable)list, MaterialResultVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u4e2d\u6807\u4f9b\u5e94\u5546\u5217\u8868\uff01", (Object)materialResultVOS);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialResultVO> queryDetail(@RequestParam Long id) {
        MaterialResultEntity entity = (MaterialResultEntity)((Object)this.service.selectById(id));
        MaterialResultVO vo = (MaterialResultVO)BeanMapper.map((Object)((Object)entity), MaterialResultVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetailByCon"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialResultVO> queryDetailByCon(@RequestBody MaterialResultVO materialResultVO) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(MaterialResultEntity::getPicketageId, (Object)materialResultVO.getPicketageId());
        lambdaQueryWrapper.eq(MaterialResultEntity::getSupplierId, (Object)materialResultVO.getSupplierId());
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        MaterialResultVO vo = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (MaterialResultVO)BeanMapper.map(list.get(0), MaterialResultVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e2d\u6807\u7ed3\u679c\u5217\u8868\u901a\u8fc7\u5b9a\u6807\u5355")
    @RequestMapping(value={"/queryListByPicketage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialResultVO>> queryListByPicketage(@RequestBody MaterialPicketageVO materialPicketageVO) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(MaterialResultEntity::getPicketageId, (Object)materialPicketageVO.getId());
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, MaterialResultVO.class));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialResultVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialResultVO materialResultVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialResultVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialResultVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialResult-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialResultData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialResultVO>> refMaterialResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("purchaseSubject");
        param.getFuzzyFields().add("purchaseTypeName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                param.getParams().put("orgId", new Parameter("eq", (Object)_con.getLong("orgId")));
            }
            if (_con.containsKey((Object)"supplierId") && _con.getLong("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)_con.getLong("supplierId")));
            }
            if (_con.containsKey((Object)"pricingType")) {
                param.getParams().put("pricingType", new Parameter("eq", (Object)_con.getLong("pricingType")));
            }
            if (_con.containsKey((Object)"purchaseType")) {
                param.getParams().put("purchaseType", new Parameter("eq", (Object)_con.getInteger("purchaseType")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialResultVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refMaterialResultPurchaseDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialResultPurchaseDetailVO>> refMaterialResultPurchaseDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("model");
        param.getFuzzyFields().add("unit");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"pid")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u5b9a\u6807\u7ed3\u679c\u5355Id\u3010pid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            param.getParams().put("pid", new Parameter("eq", (Object)_con.getLong("pid")));
        }
        IPage page = this.materialResultPurchaseDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialResultPurchaseDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refMaterialResultRentDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialResultRentDetailVO>> refMaterialResultRentDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("model");
        param.getFuzzyFields().add("unit");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"pid")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u5b9a\u6807\u7ed3\u679c\u5355Id\u3010pid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            param.getParams().put("pid", new Parameter("eq", (Object)_con.getLong("pid")));
        }
        IPage page = this.materialResultRentDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialResultRentDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

