package com.ejianc.business.bidprice.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.bidprice.material.bean.MaterialInquiryPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialInquirySupplierEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料询价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bidprice_material_inquiry")
public class MaterialInquiryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织id
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织
    @TableField(value="purchase_subject")
    private String purchaseSubject; // 采购主题
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式：1-项目自采；2-集中采购
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 采购方式名称
    @TableField(value="pricing_type")
    private Integer pricingType; // 计价方式：1-采购；2-租赁
    @TableField(value="pricing_type_name")
    private String pricingTypeName; // 计价方式名称
    @TableField(value="quotation_authority")
    private Integer quotationAuthority; // 报价权限：1-指定供应商；2-所有供应商
    @TableField(value="quotation_authority_name")
    private String quotationAuthorityName; // 报价权限名称
    @TableField(value="view_authority")
    private Integer viewAuthority; // 查看权限：1-指定供应商：2-所有供应商登录后查看；3-所有供应商免登录查看
    @TableField(value="view_authority_name")
    private String viewAuthorityName; // 查看权限名称
    @TableField(value="inquiry_mny")
    private BigDecimal inquiryMny; // 询价金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_use_date")
    private Date planUseDate; // 计划使用日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="inquiry_date")
    private Date inquiryDate; // 询价日期
    @TableField(value="contacts_id")
    private Long contactsId; // 联系人
    @TableField(value="contacts_name")
    private String contactsName; // 联系人姓名
    @TableField(value="phone")
    private String phone; // 联系电话
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @TableField(value="quote_end_date")
    private Date quoteEndDate; // 报价截止日期
    @TableField(value="invoice_requirement")
    private String invoiceRequirement; // 发票要求
    @TableField(value="payment_method")
    private String paymentMethod; // 付款方式
    @TableField(value="memo")
    private String memo; // 询价说明
    @TableField(value="inquiry_state")
    private Integer inquiryState; // 询价状态：1-未开始；2-报价中；3-已截止；4-已定标
    @TableField(value="section_names")
    private String sectionNames; //标段名称集合
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialInquiryPurchaseDetailService",pidName = "inquiryId")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialInquiryPurchaseDetailEntity> materialInquiryPurchaseDetailList = new ArrayList<>(); // 材料询价-采购清单
    @TableField(exist=false)
    @SubEntity(serviceName="materialInquiryRentDetailService",pidName = "inquiryId")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialInquiryRentDetailEntity> materialInquiryRentDetailList = new ArrayList<>(); // 材料询价-租赁清单
    @TableField(exist=false)
    @SubEntity(serviceName="materialInquirySupplierService",pidName = "inquiryId")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialInquirySupplierEntity> materialInquirySupplierList = new ArrayList<>(); // 材料询价-候选供应商


    @TableField(value="bid_process")
    private Integer bidProcess; // 招标流程：1询价2开标，默认取系统参数设置

    @TableField(value="bid_open_state")
    private Integer bidOpenState; // 开标状态


    public Integer getBidProcess() {
        return bidProcess;
    }

    public void setBidProcess(Integer bidProcess) {
        this.bidProcess = bidProcess;
    }

    public Integer getBidOpenState() {
        return bidOpenState;
    }

    public void setBidOpenState(Integer bidOpenState) {
        this.bidOpenState = bidOpenState;
    }

    public String getSectionNames() {
        return sectionNames;
    }

    public void setSectionNames(String sectionNames) {
        this.sectionNames = sectionNames;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getPurchaseSubject() {
        return purchaseSubject;
    }

    public void setPurchaseSubject(String purchaseSubject) {
        this.purchaseSubject = purchaseSubject;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }

    public String getPricingTypeName() {
        return pricingTypeName;
    }

    public void setPricingTypeName(String pricingTypeName) {
        this.pricingTypeName = pricingTypeName;
    }

    public Integer getQuotationAuthority() {
        return quotationAuthority;
    }

    public void setQuotationAuthority(Integer quotationAuthority) {
        this.quotationAuthority = quotationAuthority;
    }

    public String getQuotationAuthorityName() {
        return quotationAuthorityName;
    }

    public void setQuotationAuthorityName(String quotationAuthorityName) {
        this.quotationAuthorityName = quotationAuthorityName;
    }

    public Integer getViewAuthority() {
        return viewAuthority;
    }

    public void setViewAuthority(Integer viewAuthority) {
        this.viewAuthority = viewAuthority;
    }

    public String getViewAuthorityName() {
        return viewAuthorityName;
    }

    public void setViewAuthorityName(String viewAuthorityName) {
        this.viewAuthorityName = viewAuthorityName;
    }

    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    public Date getPlanUseDate() {
        return planUseDate;
    }

    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getInquiryDate() {
        return inquiryDate;
    }

    public void setInquiryDate(Date inquiryDate) {
        this.inquiryDate = inquiryDate;
    }
    public Long getContactsId() {
        return contactsId;
    }

    public void setContactsId(Long contactsId) {
        this.contactsId = contactsId;
    }
    public String getContactsName() {
        return contactsName;
    }

    public void setContactsName(String contactsName) {
        this.contactsName = contactsName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Date getQuoteEndDate() {
        return quoteEndDate;
    }

    public void setQuoteEndDate(Date quoteEndDate) {
        this.quoteEndDate = quoteEndDate;
    }
    public String getInvoiceRequirement() {
        return invoiceRequirement;
    }

    public void setInvoiceRequirement(String invoiceRequirement) {
        this.invoiceRequirement = invoiceRequirement;
    }
    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getInquiryState() {
        return inquiryState;
    }

    public void setInquiryState(Integer inquiryState) {
        this.inquiryState = inquiryState;
    }
    
    public List<MaterialInquiryPurchaseDetailEntity> getMaterialInquiryPurchaseDetailList() {
        return materialInquiryPurchaseDetailList;
    }

    public void setMaterialInquiryPurchaseDetailList(List<MaterialInquiryPurchaseDetailEntity> materialInquiryPurchaseDetailList) {
        this.materialInquiryPurchaseDetailList = materialInquiryPurchaseDetailList;
    }
    public List<MaterialInquiryRentDetailEntity> getMaterialInquiryRentDetailList() {
        return materialInquiryRentDetailList;
    }

    public void setMaterialInquiryRentDetailList(List<MaterialInquiryRentDetailEntity> materialInquiryRentDetailList) {
        this.materialInquiryRentDetailList = materialInquiryRentDetailList;
    }
    public List<MaterialInquirySupplierEntity> getMaterialInquirySupplierList() {
        return materialInquirySupplierList;
    }

    public void setMaterialInquirySupplierList(List<MaterialInquirySupplierEntity> materialInquirySupplierList) {
        this.materialInquirySupplierList = materialInquirySupplierList;
    }
}
