package com.ejianc.business.desktop.api;

import com.ejianc.business.desktop.hystrix.BpmMessageHystrix;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 *
 * bpm数据库消息查询接口
 * @author Jiang
 *
 */
@FeignClient(name= "ejc-bpmdesktop-web", url="${common.env.feign-client-url}", path="ejc-bpmdesktop-web", fallback = BpmMessageHystrix.class)
public interface IBpmMessageApi {

	/**
	 * 根据单据编号、单据编码查询消息主体，以及是否已读
	 * @return
	 */
	@GetMapping(value = "/api/bpmMessage/queryBpmMessage")
    CommonResponse<List<BpmSendMessageVO>> queryBpmMessage(@RequestParam(value = "billCode",required = true)String billCode,
														   @RequestParam(value = "billTypeName",required = true) String billTypeName);

}
