package com.ejianc.business.desktop.api;

import com.ejianc.business.desktop.hystrix.IdmUserHystrix;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 *
 *
 * bpm数据库消息查询接口
 * @author Jiang
 *
 */
@FeignClient(name= "ejc-bpmdesktop-web", url="${common.env.feign-client-url}", path="ejc-bpmdesktop-web", fallback = IdmUserHystrix.class)
public interface IIdmUserApi {

	/**
	 * 根据时间获取该时间之后新增或更新的人员数据
	 * @return
	 */
	@GetMapping(value = "/api/idm/syncUserDataByTime")
    CommonResponse<List<SalaryUserVO>> syncUserDataByTime(@RequestParam(value = "time") String time);

	@GetMapping(value = "/api/idm/getOrgCodeList")
	CommonResponse<List<String>> getOrgCodeList(@RequestParam(value = "orgId") Long orgId);


	@GetMapping(value = "/api/idm/getWeixineeIdList")
	CommonResponse<List<UserVO>> getWeixineeIdList();

	@GetMapping(value = "/api/idm/getUserByWeixineeId")
	CommonResponse<UserVO> getUserByWeixineeId(@RequestParam(value = "weixineeId") String weixineeId);

	@GetMapping(value = "/api/idm/getUserByWeixineeCode")
	CommonResponse<UserVO> getUserByWeixineeCode(@RequestParam(value = "weixineeCode") String weixineeCode);
}
