package com.ejianc.business.desktop.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.desktop.service.IWarnService;
import com.ejianc.business.desktop.vo.TaskVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author:sunxy
 * @Description:超期待办预警
 * @date 2022/6/6 11:22
 */
@RestController
@RequestMapping(value = "/warn/")
public class WarnController {
//       * * * 26 * ?            {"dispatchCode":"WARNING000110"}
   //    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarnService warnService;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IOrgApi iOrgApi;

    static  String  PC_URL = "/ejc-task-frontend/#/personWarnCenter";
    static  String  PC_URL1 = "/ejc-message-frontend/#/message?msgType=bpmurge";
    static  String  TEST_AGENTID = "1000038";
    static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static  String  PRO_AGENTID = "1000036";
    static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";


    @Autowired
    private IPushMessageApi pushMessageApi;
    //预警代办提醒
    public boolean sendSys(String receiverId,Integer sum){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {receiverId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("earlywarning");//预警消息
        parameter.setSubject("您共有"+sum+"个预警超期未处理！");// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl(PC_URL);// pc端url
        parameter.setMobileUrl(PC_URL);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", "1000036");//企业微信应用id
        weixineeParams.put("secret", "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40");//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "预警超期未处理通知");
        weixineeParams.put("description", "您共有"+sum+"个预警超期未处理！请前往电脑端查看！");
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
                "&targeturl=https%3A%2F%2Fpms.zzyjjt.com%2Fejc-task-frontend%2F%23%2FpersonWarnCenter"));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.error("消息发送成功---------------->,接收人:{}," + result.getMsg(), Arrays.toString(receivers));

            return true;
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return false;
        }
    }


    @PostMapping(value = "execute")
    public CommonResponse<List<JSONObject>> execute(HttpServletRequest request) {
        logger.info("消息发送前1---------------->");
        List<TaskVO> enrollEntities = warnService.selectWarnList();
        logger.info("消息发送前2---------------->");
        //发送消息
        for (TaskVO taskEntity : enrollEntities) {
            sendSys(taskEntity.getReceiverId()+"",taskEntity.getSum());
            try {
                //睡眠0.5s
                Thread.currentThread().sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success("执行成功！");
    }


    //流程代办提醒
    public boolean sendSys1(String receiverId,Integer sum){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {receiverId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("earlywarning");//预警消息
        parameter.setSubject("您共有"+sum+"条待办（含预警任务）超48小时未处理，请到（待办中心或消息-流程催办提醒）及时处理！");// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl(PC_URL1);// pc端url
        parameter.setMobileUrl(PC_URL1);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid",PRO_AGENTID);//企业微信应用id
        weixineeParams.put("secret", PRO_SECRET);//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "流程审批超期未处理通知");
        weixineeParams.put("description", "您共有"+sum+"条待办（含预警任务）超48小时未处理，请到（待办中心或消息-流程催办提醒）及时处理！请前往电脑端查看！");
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
                "&targeturl=https%3A%2F%2Fpms.zzyjjt.com%2Fejc-message-frontend%2F%23%2Fmessage%3FmsgType%3Dbpmurge"));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.info("消息发送成功---------------->,接收人:{},数量：{}", Arrays.toString(receivers),sum);

            return true;
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return false;
        }
    }

    @PostMapping(value = "executeMsg")
    public CommonResponse<List<JSONObject>> executeMsg(HttpServletRequest request) {
        logger.info("消息发送前1---------------->");
        List<TaskVO> enrollEntities = warnService.selectMsgWarnList();
        logger.info("消息发送前2---------------->");
        //发送消息
        for (TaskVO taskEntity : enrollEntities) {
            sendSys1(taskEntity.getReceiverId()+"",taskEntity.getSum());
            try {
                //睡眠0.5s
                Thread.currentThread().sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success("执行成功！");
    }
}