/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.desktop.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.bean.ProjectSetPoolEntity;
import com.ejianc.business.desktop.bean.ProjectStatusEntity;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.vo.ProjectPoolSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectSetPool"})
public class ProjectSetPoolController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private SessionManager sessionManager;
    private static String RANGE_ALL = "all";

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refProjectSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refProjectSetData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long batchId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("projectStatus", new Parameter("eq", (Object)batchId));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String parentProjectId = _con.getString("parentProjectId");
            if (StringUtils.isNotBlank((CharSequence)parentProjectId)) {
                param.getParams().put("parentProjectId", new Parameter("eq", (Object)parentProjectId));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("orgId"))) {
                orgId = _con.getLong("orgId");
            }
            Page page1 = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            String rangeType = _con.getString("range");
            if (StringUtils.isNotEmpty((CharSequence)rangeType) && RANGE_ALL.equals(rangeType)) {
                QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
                List<ProjectSetPoolEntity> projectSetPoolEntities = this.projectSetService.queryMyPage((Page<ProjectSetPoolEntity>)page1, wrapper);
                Page pageData = new Page(page1.getCurrent(), page1.getSize(), page1.getTotal());
                pageData.setRecords(BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class));
                List records = pageData.getRecords();
                if (ListUtil.isNotEmpty((List)records)) {
                    records.forEach(projectSetVO -> {
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("parentProjectId", new Parameter("eq", (Object)projectSetVO.getId()));
                        List entityList = this.projectSetService.queryList(queryParam, false);
                        if (ListUtil.isNotEmpty((List)entityList)) {
                            ArrayList<ProjectPoolSetVO> projectSetVOS = new ArrayList<ProjectPoolSetVO>();
                            for (int i = 0; i < entityList.size(); ++i) {
                                ProjectPoolSetVO setVO = (ProjectPoolSetVO)BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                projectSetVOS.add(setVO);
                            }
                            projectSetVO.setChildren(projectSetVOS);
                        }
                    });
                }
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("excludeCapitalStatus"))) {
                param.getParams().put("capitalStatus", new Parameter("not_in", (Object)_con.getString("excludeCapitalStatus")));
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Page page1 = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProjectSetPoolEntity> projectSetPoolEntities = this.projectSetService.queryMyPage((Page<ProjectSetPoolEntity>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refProjectStatusTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectStatusEntity> refProjectStatusTree(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        ArrayList<ProjectStatusEntity> list = new ArrayList<ProjectStatusEntity>();
        ProjectStatusEntity projectStatusEntity = new ProjectStatusEntity();
        projectStatusEntity.setCode("1");
        projectStatusEntity.setId("1");
        projectStatusEntity.setName("\u5728\u5efa");
        list.add(projectStatusEntity);
        ProjectStatusEntity projectStatusEntity1 = new ProjectStatusEntity();
        projectStatusEntity1.setCode("2");
        projectStatusEntity1.setId("2");
        projectStatusEntity1.setName("\u9879\u76ee\u4e2d\u6b62");
        list.add(projectStatusEntity1);
        ProjectStatusEntity projectStatusEntity2 = new ProjectStatusEntity();
        projectStatusEntity2.setCode("3");
        projectStatusEntity2.setId("3");
        projectStatusEntity2.setName("\u7ae3\u5de5");
        list.add(projectStatusEntity2);
        ProjectStatusEntity projectStatusEntity3 = new ProjectStatusEntity();
        projectStatusEntity3.setCode("4");
        projectStatusEntity3.setId("4");
        projectStatusEntity3.setName("\u5408\u540c\u72b6\u6001");
        list.add(projectStatusEntity3);
        ProjectStatusEntity projectStatusEntity4 = new ProjectStatusEntity();
        projectStatusEntity4.setCode("5");
        projectStatusEntity4.setId("5");
        projectStatusEntity4.setName("\u51b3\u7b97\u72b6\u6001");
        list.add(projectStatusEntity4);
        ProjectStatusEntity projectStatusEntity5 = new ProjectStatusEntity();
        projectStatusEntity5.setCode("6");
        projectStatusEntity5.setId("6");
        projectStatusEntity5.setName("\u8d44\u6599\u72b6\u6001");
        list.add(projectStatusEntity5);
        ProjectStatusEntity projectStatusEntity6 = new ProjectStatusEntity();
        projectStatusEntity6.setCode("7");
        projectStatusEntity6.setId("7");
        projectStatusEntity6.setName("\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001");
        list.add(projectStatusEntity6);
        return list;
    }
}

