package com.ejianc.business.desktop.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.bean.ProjectSetExPoolEntity;
import com.ejianc.business.desktop.bean.ProjectSetPoolEntity;
import com.ejianc.business.desktop.mapper.ProjectSetMapper;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.business.desktop.vo.ProjectPoolSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgNoAuthApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;

import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
@Transactional
public class ProjectSetServiceImpl extends BaseServiceImpl<ProjectSetMapper, ProjectSetPoolEntity> implements IProjectSetService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public List<ProjectSetPoolEntity> queryMyPage(Page<ProjectSetPoolEntity> page, QueryWrapper wrapper) {
        return baseMapper.queryMyPage(page, wrapper);
    }

    @Override
    public List<ProjectSetExPoolEntity> queryMyPageEx(Page<ProjectSetExPoolEntity> page, QueryWrapper wrapper) {
        return baseMapper.queryMyPageEx(page, wrapper);
    }

    @Override
    public List<CategoryVO> queryCategory(List<String> innerCode) {
        return baseMapper.queryCategory(innerCode);
    }

    @Override
    public Long queryUserIdByCard(String card) {
        return baseMapper.queryUserIdByCard(card);
    }
}
