package com.ejianc.business.desktop.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.service.IUserInfoService;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

/**
 *
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/idm")
public class UserInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private IUserInfoService service;

    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/queryUserIdByCard", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Long> queryUserIdByCard(@RequestParam String card) {
        //获取用户的id
        return CommonResponse.success("查询详情数据成功！",projectSetService.queryUserIdByCard(card));
    }


    /**
     * @Description 对比人力数据是否同步
     * @param
     */
    @RequestMapping(value = "/queryUserSyncState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryUserSyncState(@RequestParam(required = true) Integer property,
                                                    @RequestParam(required = true) String idCard,
                                                   @RequestParam(required = false) String orgCode,
                                                   @RequestParam(required = false) String deptCode,
                                                   @RequestParam(required = false) String postCode,
                                                   @RequestParam(required = false) String jobStartTime) {

        List<Long> longs =  projectSetService.queryUserSyncState(property,idCard, orgCode, deptCode, postCode, jobStartTime);


        if(CollectionUtils.isNotEmpty(longs)){
            return CommonResponse.success("查询详情数据成功！",true);
        }
        return CommonResponse.success("查询详情数据成功！",false);

    }


    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/syncUserDataByTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SalaryUserVO>> syncUserDataByTime(@RequestParam(value = "time") String time){
        //
        return CommonResponse.success("查询详情数据成功！",service.syncUserDataByTime(time));
    }


    /**
     * 根据orgId获取下面的部门Code
     *
     * @param
     * @return
     */
    @GetMapping("getOrgCodeList")
    public CommonResponse<List<String>> getOrgCodeList(@RequestParam(value = "orgId")  Long orgId) {
        List<String> orgCodeList = service.getOrgCodeList(orgId);
        return CommonResponse.success("查询成功！",orgCodeList);
    }

}

