package com.ejianc.business.desktop.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.bean.ProjectSetExPoolEntity;
import com.ejianc.business.desktop.bean.ProjectSetPoolEntity;
import com.ejianc.business.desktop.bean.ProjectStatusEntity;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.vo.ProjectPoolSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目WBS
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectSetPool")
public class ProjectSetPoolController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProjectSetService projectSetService;


    @Autowired
    private SessionManager sessionManager;

    private static String RANGE_ALL="all";







    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * @Description 参照  执行项目
     *
     * @Return void
     */
    @RequestMapping(value = "/refProjectSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refProjectSetData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                     @RequestParam(defaultValue = "10") int pageSize,
                                                                     @RequestParam(required=false) String relyCondition,
                                                                     @RequestParam(required=false) String condition,
                                                                     @RequestParam(required=false) String searchObject,
                                                                     @RequestParam(required=false) String searchText,
                                                                     @RequestParam(required=false) Integer businessStatus) {
        logger.info("开始查询项目信息接口---------");
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("orgName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();

        if(StringUtils.isNotBlank(relyCondition)){
            //当为树表参照时适配（以树节点为主）
            Long batchId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("projectStatus", new Parameter(QueryParam.EQ, batchId));
//            IPage<BatchPlanDetailEntity> page = service.queryPage(queryParam, false);
//            IPage<BatchPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//            pageData.setRecords(BeanMapper.mapList(page.getRecords(), BatchPlanDetailVO.class));
//            return CommonResponse.success("查询参照数据成功！",pageData);
        }
        if (businessStatus != null){
            param.getParams().put("businessStatus", new Parameter(QueryParam.EQ, businessStatus));
        }

        /**
         * 根据需求 修改为
         * 查询 “执行项目”
         * 2022-7-27
         * */
//        param.getParams().put("attribute",new Parameter(QueryParam.EQ,2));
//        param.getParams().put("projectStatus",new Parameter(QueryParam.EQ,1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);

            String parentProjectId = _con.getString("parentProjectId");
            if(StringUtils.isNotBlank(parentProjectId)){
                param.getParams().put("parentProjectId",new Parameter(QueryParam.EQ,parentProjectId));
            }
            String projectDepartmentId = _con.getString("projectDepartmentId");
            if(StringUtils.isNotBlank(projectDepartmentId)){
                param.getParams().put("projectDepartmentId",new Parameter(QueryParam.EQ,projectDepartmentId));
            }
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
                List<OrgVO> orgVOList = null;
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
                //普通组织 id
                List<Long> commonOrgIds = new ArrayList<>();
                orgVOList.stream().forEach(org -> {
                    commonOrgIds.add(org.getId());
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    /** 要求主表有orgId字段，保存单据所属组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                }
            }
            //调入项目不要组织过滤
            //自定义查询，拼接查询语句
            Page<ProjectSetPoolEntity> page1 = new Page<>(param.getPageIndex(), param.getPageSize());
            String rangeType = _con.getString("range");
            if (StringUtils.isNotEmpty(rangeType)){
                logger.info("项目信息查询参数开始---------");
                if (RANGE_ALL.equals(rangeType)){
                    QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
                    List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.queryMyPage(page1, wrapper);
                    IPage<ProjectPoolSetVO> pageData = new Page<>(page1.getCurrent(), page1.getSize(), page1.getTotal());
                    pageData.setRecords(BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class));
                    List<ProjectPoolSetVO> records = pageData.getRecords();
                    if(ListUtil.isNotEmpty(records))
                    records.forEach(projectSetVO -> {

                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("parentProjectId", new Parameter(QueryParam.EQ, projectSetVO.getId()));
                        List<ProjectSetPoolEntity> entityList = projectSetService.queryList(queryParam, false);

                        if(ListUtil.isNotEmpty(entityList)) {
                            List<ProjectPoolSetVO> projectSetVOS = new ArrayList<>();
                            for (int i = 0; i < entityList.size(); i++) {
                                ProjectPoolSetVO setVO = BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                projectSetVOS.add(setVO);
                            }
                            projectSetVO.setChildren(projectSetVOS);
                        }
                    });
                    return CommonResponse.success("查询参照数据成功！",pageData);
                }
            }

            //过滤指定资金管控状态状态的项目 modify by cj 2022年9月9日14:37:54
            if(StringUtils.isNotBlank(_con.getString("excludeCapitalStatus"))){
                param.getParams().put("capitalStatus", new Parameter(QueryParam.NOT_IN, _con.getString("excludeCapitalStatus")));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
//        }else {
//            return CommonResponse.success("查询参照数据成功！",new Page<>(0, 0, 0));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        Page<ProjectSetPoolEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());

        Page<ProjectSetExPoolEntity> page1 = new Page<>(param.getPageIndex(), param.getPageSize());

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.queryMyPage(page, wrapper);

        //List<ProjectSetExPoolEntity> projectSetPoolEntities1 = projectSetService.queryMyPageEx(page1, wrapper);


       // List<ProjectSetPoolEntity> projectPoolSetVOS = BeanMapper.mapList(projectSetPoolEntities1, ProjectSetPoolEntity.class);

        //projectSetPoolEntities.addAll(projectPoolSetVOS);

        IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class));
        logger.info("项目信息查询结束---------");
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照  执行项目
     *
     * @Return void
     */
    @RequestMapping(value = "/api/queryProjectSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectSetData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                     @RequestParam(defaultValue = "10") int pageSize,
                                                                     @RequestParam(required=false) String relyCondition,
                                                                     @RequestParam(required=false) String condition,
                                                                     @RequestParam(required=false) String searchObject,
                                                                     @RequestParam(required=false) String searchText) {
        logger.info("开始查询项目信息接口---------");
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();

        if(StringUtils.isNotBlank(relyCondition)){
            //当为树表参照时适配（以树节点为主）
            Long batchId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("projectStatus", new Parameter(QueryParam.EQ, batchId));
//            IPage<BatchPlanDetailEntity> page = service.queryPage(queryParam, false);
//            IPage<BatchPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//            pageData.setRecords(BeanMapper.mapList(page.getRecords(), BatchPlanDetailVO.class));
//            return CommonResponse.success("查询参照数据成功！",pageData);
        }

        /**
         * 根据需求 修改为
         * 查询 “执行项目”
         * 2022-7-27
         * */
//        param.getParams().put("attribute",new Parameter(QueryParam.EQ,2));
//        param.getParams().put("projectStatus",new Parameter(QueryParam.EQ,1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);

            String parentProjectId = _con.getString("parentProjectId");
            if(StringUtils.isNotBlank(parentProjectId)){
                param.getParams().put("parentProjectId",new Parameter(QueryParam.EQ,parentProjectId));
            }
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
                List<OrgVO> orgVOList = null;
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
                //普通组织 id
                List<Long> commonOrgIds = new ArrayList<>();
                orgVOList.stream().forEach(org -> {
                    commonOrgIds.add(org.getId());
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    /** 要求主表有orgId字段，保存单据所属组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                }
            }
            //调入项目不要组织过滤
            //自定义查询，拼接查询语句
            Page<ProjectSetPoolEntity> page1 = new Page<>(param.getPageIndex(), param.getPageSize());
            String rangeType = _con.getString("range");
            if (StringUtils.isNotEmpty(rangeType)){
                logger.info("项目信息查询参数开始---------");
                if (RANGE_ALL.equals(rangeType)){
                    QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
                    List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.queryMyPage(page1, wrapper);
                    IPage<ProjectPoolSetVO> pageData = new Page<>(page1.getCurrent(), page1.getSize(), page1.getTotal());
                    pageData.setRecords(BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class));
                    List<ProjectPoolSetVO> records = pageData.getRecords();
                    if(ListUtil.isNotEmpty(records))
                        records.forEach(projectSetVO -> {

                            QueryParam queryParam = new QueryParam();
                            queryParam.getParams().put("parentProjectId", new Parameter(QueryParam.EQ, projectSetVO.getId()));
                            List<ProjectSetPoolEntity> entityList = projectSetService.queryList(queryParam, false);

                            if(ListUtil.isNotEmpty(entityList)) {
                                List<ProjectPoolSetVO> projectSetVOS = new ArrayList<>();
                                for (int i = 0; i < entityList.size(); i++) {
                                    ProjectPoolSetVO setVO = BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                    projectSetVOS.add(setVO);
                                }
                                projectSetVO.setChildren(projectSetVOS);
                            }
                        });
                    return CommonResponse.success("查询参照数据成功！",records);

                }
            }

            //过滤指定资金管控状态状态的项目 modify by cj 2022年9月9日14:37:54
            if(StringUtils.isNotBlank(_con.getString("excludeCapitalStatus"))){
                param.getParams().put("capitalStatus", new Parameter(QueryParam.NOT_IN, _con.getString("excludeCapitalStatus")));
            }
        }
        Page<ProjectSetPoolEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());

        Page<ProjectSetExPoolEntity> page1 = new Page<>(param.getPageIndex(), param.getPageSize());

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.queryMyPage(page, wrapper);

        //List<ProjectSetExPoolEntity> projectSetPoolEntities1 = projectSetService.queryMyPageEx(page1, wrapper);


        // List<ProjectSetPoolEntity> projectPoolSetVOS = BeanMapper.mapList(projectSetPoolEntities1, ProjectSetPoolEntity.class);

        //projectSetPoolEntities.addAll(projectPoolSetVOS);

        List<ProjectPoolSetVO> projectPoolSetVOS = BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class);
        logger.info("项目信息查询结束---------");
        return CommonResponse.success("查询参照数据成功！",projectPoolSetVOS);
    }
    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectStatusTree", method = RequestMethod.GET)
    @ResponseBody
    public List<ProjectStatusEntity> refProjectStatusTree(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                  @RequestParam(defaultValue = "10") Integer pageSize,
                                                  @RequestParam(value = "searchText", required = false) String searchText,
                                                  @RequestParam(value = "condition", required = false) String condition) {

        List<ProjectStatusEntity> list = new ArrayList<>();
        ProjectStatusEntity projectStatusEntity = new ProjectStatusEntity();
        projectStatusEntity.setCode("1");
        projectStatusEntity.setId("1");
        projectStatusEntity.setName("在建");
        list.add(projectStatusEntity);

        ProjectStatusEntity projectStatusEntity1 = new ProjectStatusEntity();
        projectStatusEntity1.setCode("2");
        projectStatusEntity1.setId("2");
        projectStatusEntity1.setName("项目中止");
        list.add(projectStatusEntity1);

        ProjectStatusEntity projectStatusEntity2 = new ProjectStatusEntity();
        projectStatusEntity2.setCode("3");
        projectStatusEntity2.setId("3");
        projectStatusEntity2.setName("竣工");
        list.add(projectStatusEntity2);

        ProjectStatusEntity projectStatusEntity3 = new ProjectStatusEntity();
        projectStatusEntity3.setCode("4");
        projectStatusEntity3.setId("4");
        projectStatusEntity3.setName("合同状态");
        list.add(projectStatusEntity3);

        ProjectStatusEntity projectStatusEntity4 = new ProjectStatusEntity();
        projectStatusEntity4.setCode("5");
        projectStatusEntity4.setId("5");
        projectStatusEntity4.setName("决算状态");
        list.add(projectStatusEntity4);

        ProjectStatusEntity projectStatusEntity5 = new ProjectStatusEntity();
        projectStatusEntity5.setCode("6");
        projectStatusEntity5.setId("6");
        projectStatusEntity5.setName("资料状态");
        list.add(projectStatusEntity5);

        ProjectStatusEntity projectStatusEntity6 = new ProjectStatusEntity();
        projectStatusEntity6.setCode("7");
        projectStatusEntity6.setId("7");
        projectStatusEntity6.setName("资金管控状态");
        list.add(projectStatusEntity6);

        return list;
    }










}

