package com.ejianc.business.desktop.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.mapper.ReportMapper;
import com.ejianc.business.desktop.mapper.TaskinstMapper;
import com.ejianc.business.desktop.service.IReportService;
import com.ejianc.business.desktop.service.ITaskinstService;
import com.ejianc.business.desktop.vo.BpmVariableVO;
import com.ejianc.business.desktop.vo.ReportDataVO;
import com.ejianc.business.desktop.vo.TaskinstVO;
import com.ejianc.business.desktop.vo.UserInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 流程主题门户接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("report")
public class ReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IReportService service;
    @Autowired
    private ReportMapper mapper;
    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/queryData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReportDataVO> queryData(@RequestBody QueryParam param) {
        ReportDataVO reportDataVOS = mapper.queryData(param);
        return CommonResponse.success("查询详情数据成功！",reportDataVOS);
    }
}
