package com.ejianc.business.desktop.controller.api;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.desktop.service.IBpmMessageService;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/bpmMessage")
public class BpmMessageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBpmMessageService bpmMessageService;


    /**
     * 查询消息回执，发送消息是否已读
     * @Description
     * @param
     */
    @RequestMapping(value = "/queryBpmMessage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BpmSendMessageVO>> queryBpmMessage(@RequestParam(value = "billCode",required = true)String billCode,
                                                            @RequestParam(value = "billTypeName",required = true) String billTypeName) {
        logger.info("查询消息回执接口开始，接受参数为billCode={},billTypeName={}",billCode,billTypeName);
        List<BpmSendMessageVO> bpmSendMessageVOS = bpmMessageService.queryBpmMessage(billCode, billTypeName);
        logger.info("查询消息回执接口结束，返回数据为{}", JSON.toJSONString(bpmSendMessageVOS));


        return CommonResponse.success("查询详情数据成功！",bpmSendMessageVOS);
    }

    /**
     * 所属巡检组档案角色关联
     * @Description
     * @param
     */
    @RequestMapping(value = "/queryGroupRoleUser", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> queryGroupRoleUser(Long docId) {
        List<String> list = bpmMessageService.selectGroupRoleUserRef(docId);
        return CommonResponse.success("查询详情数据成功！",list);
    }


}

