package com.ejianc.business.desktop.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.TaskinstVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.desktop.mapper.TaskinstMapper;
import com.ejianc.business.desktop.bean.TaskinstEntity;
import com.ejianc.business.desktop.service.ITaskinstService;

import java.util.Date;
import java.util.List;

/**
 * 流程主题门户接口
 * 
 * @author generator
 * 
 */
@Service("taskinstService")
public class TaskinstServiceImpl extends BaseServiceImpl<TaskinstMapper, TaskinstEntity> implements ITaskinstService{

    @Override
    public List<TaskinstVO> queryLastYearUser(Page<TaskinstVO> page, Long userId, Long orgId,Long deptId, Date start, Date end,
                                              String timeSort, String count,String sumTime,String orgCode,String searchText) {
        return baseMapper.queryLastYearUser(page,userId, orgId,deptId, start,end,timeSort,count,sumTime,orgCode,searchText);
    }

    @Override
    public List<TaskinstVO> queryUserDetail(Page<TaskinstVO> page,Long userId, Date start, Date end,String stateFlag) {
        return baseMapper.queryUserDetail(page,userId, start,end, stateFlag);
    }

    @Override
    public List<TaskinstVO> queryYearOrg(Page<TaskinstVO> page, List<Long> orgId, Date start, Date end,String timeSort,
                                         Long deptId,String groupFlag,String count,String sumTime,String orgCode,String searchText) {
        return baseMapper.queryYearOrg(page,orgId,start,end,timeSort,deptId,groupFlag,count,sumTime,orgCode,searchText);
    }

    @Override
    public List<TaskinstVO> queryYearOrgUnder(Page<TaskinstVO> page, List<Long> orgId, Date start, Date end,String timeSort,
                                         Long deptId,String groupFlag,String count,String sumTime,
                                              String orgCode,String searchText,String glcFlag) {
        return baseMapper.queryYearOrgUnder(page,orgId,start,end,timeSort,deptId,groupFlag,count,sumTime,orgCode,searchText,glcFlag);
    }

    @Override
    public List<TaskinstVO> queryTolalInfo(Long orgId,Long deptId, Date start, Date end) {
        return baseMapper.queryTolalInfo(orgId,deptId,start,end);
    }

    @Override
    public List<TaskinstVO> queryYearBill(Page<TaskinstVO> page, String billName, Date start, Date end, String timeSort,
                                          String stateFlag, List<Long> orgId,String searchText) {
        return baseMapper.queryYearBill(page,billName,start,end,timeSort,stateFlag,orgId,searchText);
    }

    @Override
    public List<TaskinstVO> queryYearOrgLimit5(Page<TaskinstVO> page, List<Long> orgId, Date start, Date end, String timeSort) {
        return baseMapper.queryYearOrgLimit5(page,orgId,start,end,timeSort);
    }

    @Override
    public List<TaskinstVO> queryTimeOut(Page<TaskinstVO> page, Long userId, Date start, Date end, String timeSort, List<Long> orgId) {
        return baseMapper.queryTimeOut(page,userId,start,end,timeSort,orgId);
    }

    @Override
    public List<TaskinstVO> queryTimeOutDetail(Page<TaskinstVO> page, Long userId) {
        return baseMapper.queryTimeOutDetail(page,userId);
    }
    @Override
    public List<TaskinstVO> queryRejectException(Page<TaskinstVO> page, Long userId, Date start, Date end, String timeSort) {
        return baseMapper.queryRejectException(page,userId,start,end,timeSort);
    }

    @Override
    public List<TaskinstVO> queryYearOrgList(Page<TaskinstVO> page, List<Long> orgId, Date start, Date end, String timeSort, Long deptId) {
        return baseMapper.queryYearOrgList(page,orgId,start,end,timeSort,deptId);
    }

    @Override
    public List<TaskinstVO> queryYearBillUserDetail(Page<TaskinstVO> page, String billName, Date start, Date end, String timeSort, String billType) {
        return baseMapper.queryYearBillUserDetail(page,billName,start,end,timeSort,billType);
    }

    @Override
    public List<TaskinstVO> queryYearBillDetail(Page<TaskinstVO> page, String billName, Date start, Date end, String timeSort, String billType) {
        return baseMapper.queryYearBillDetail(page,billName,start,end,timeSort,billType);
    }
}
