/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.desktop.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.service.IUserInfoService;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/idm"})
public class UserInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IUserInfoService service;

    @RequestMapping(value={"/queryUserIdByCard"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Long> queryUserIdByCard(@RequestParam String card) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.projectSetService.queryUserIdByCard(card));
    }

    @RequestMapping(value={"/queryUserSyncState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryUserSyncState(@RequestParam(required=true) Integer property, @RequestParam(required=true) String idCard, @RequestParam(required=false) String orgCode, @RequestParam(required=false) String deptCode, @RequestParam(required=false) String postCode, @RequestParam(required=false) String jobStartTime) {
        List<Long> longs = this.projectSetService.queryUserSyncState(property, idCard, orgCode, deptCode, postCode, jobStartTime);
        if (CollectionUtils.isNotEmpty(longs)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)true);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)false);
    }

    @RequestMapping(value={"/syncUserDataByTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SalaryUserVO>> syncUserDataByTime(@RequestParam(value="time") String time) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.syncUserDataByTime(time));
    }

    @GetMapping(value={"getOrgCodeList"})
    public CommonResponse<List<String>> getOrgCodeList(@RequestParam(value="orgId") Long orgId) {
        List<String> orgCodeList = this.service.getOrgCodeList(orgId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", orgCodeList);
    }

    @RequestMapping(value={"refUserPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UserRefVO>> refUserPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)relyCondition)) {
            Long orgId = Long.parseLong(relyCondition.split("=")[1]);
            OrgVO orgVo = this.service.queryDetail(orgId);
            if (orgVo != null) {
                params.put("innerCode", orgVo.getInnerCode());
            } else {
                params.put("deptId", orgId);
            }
        }
        if (StringUtils.isNotBlank((String)condition)) {
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            if (!params.containsKey("innerCode") && !params.containsKey("deptId") && conditionJson.get((Object)"deptOrOrgId") != null) {
                Long orgId = Long.parseLong(conditionJson.get((Object)"deptOrOrgId").toString());
                OrgVO orgVo = this.service.queryDetail(orgId);
                if (orgVo != null) {
                    params.put("innerCode", orgVo.getInnerCode());
                } else {
                    params.put("deptId", orgId);
                }
            }
            if (conditionJson.get((Object)"roleId") != null) {
                params.put("roleId", Long.parseLong(conditionJson.get((Object)"roleId").toString()));
            } else {
                params.put("allProperty", "allProperty");
            }
            if (conditionJson.get((Object)"property") != null) {
                params.put("property", Long.parseLong(conditionJson.get((Object)"property").toString()));
                if (params.get("allProperty") != null) {
                    params.remove("allProperty");
                }
            }
            if (conditionJson.get((Object)"empState") != null) {
                params.put("empState", Integer.parseInt(conditionJson.get((Object)"empState").toString()));
            }
            if (conditionJson.get((Object)"userType") != null) {
                params.put("userType", Integer.parseInt(conditionJson.get((Object)"userType").toString()));
            }
            if (conditionJson.get((Object)"postNull") != null) {
                params.put("postNull", "true");
            }
        } else {
            params.put("allProperty", "allProperty");
        }
        if (StringUtils.isNotBlank((String)searchText)) {
            params.put("searchText", searchText);
        }
        params.put("pageNumber", pageNumber);
        params.put("pageSize", pageSize);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"mobilePhone") != null) {
                params.put("mobilePhone", search.get((Object)"mobilePhone").toString());
            }
            if (search.get((Object)"userName") != null) {
                params.put("userName", search.get((Object)"userName").toString());
            }
            if (search.get((Object)"jobType") != null && params.get("property") == null) {
                if ("\u76f4\u5c5e".equals(search.get((Object)"jobType").toString())) {
                    params.put("property", 1L);
                    if (params.get("allProperty") != null) {
                        params.remove("allProperty");
                    }
                }
                if ("\u96b6\u5c5e".equals(search.get((Object)"jobType").toString())) {
                    params.put("property", 0L);
                    if (params.get("allProperty") != null) {
                        params.remove("allProperty");
                    }
                }
            }
            if (search.get((Object)"orgName") != null) {
                params.put("orgName", search.get((Object)"orgName").toString());
            }
        }
        IPage<UserRefVO> dataList = this.service.pageList(params);
        dataList.setCurrent((long)pageNumber);
        dataList.setSize((long)pageSize);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", dataList);
    }

    @RequestMapping(value={"/getWeixineeIdList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UserVO>> getWeixineeIdList() {
        this.logger.info("getWeixineeIdList");
        List<UserVO> stringList = this.service.getWeixineeIdList();
        this.logger.info("getWeixineeIdList\u83b7\u53d6\u7684\u4e2a\u6570" + stringList.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", stringList);
    }

    @RequestMapping(value={"/getUserByWeixineeId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UserVO> getUserByWeixineeId(@RequestParam(value="weixineeId") String weixineeId) {
        this.logger.info("getWeixineeIdList");
        UserVO stringList = this.service.getUserByWeixineeId(weixineeId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)stringList);
    }

    @RequestMapping(value={"/getUserByWeixineeCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UserVO> getUserByWeixineeCode(@RequestParam(value="weixineeCode") String weixineeCode) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.getUserByWeixineeId(weixineeCode));
    }
}

