package com.ejianc.foundation.budgetmanage.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;


/**
 * 分包施工图预算
 * 
 * @author generator
 * 
 */
public class SubpackageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long contract; // 合同
    private String contractName; // 合同名称
    private Long subcontractUnit; // 分包单位
    private String subcontractUnitName; // 分包单位名称
    private java.math.BigDecimal excludingTaxTotal; // 除税合价合计
    private java.math.BigDecimal includingTaxTotal; // 含税合价合计
    private java.math.BigDecimal excludingTaxUnitPriceTotal; // 除税单价合计
    private java.math.BigDecimal includingTaxUnitPriceTotal; // 含税单价合计

    private String createTimeShow; // 创建时间文本显示
    private String billStateStr; // 单据状态文本显示
    private String sort; // 序号

    private Long isEnable; //是否开启控制
    private String middleId;

    private List<SubpackagedetailVO> subpackagedetailEntities = new ArrayList<>(); // 分包施工图预算子表

    public String getMiddleId() {
        return middleId;
    }

    public void setMiddleId(String middleId) {
        this.middleId = middleId;
    }

    public Long getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Long isEnable) {
        this.isEnable = isEnable;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 合同
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getContract() {
        return contract;
    }

    /**
     * 合同
     */
    @ReferDeserialTransfer
    public void setContract(Long contract) {
        this.contract = contract;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 分包单位
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSubcontractUnit() {
        return subcontractUnit;
    }

    /**
     * 分包单位
     */
    @ReferDeserialTransfer
    public void setSubcontractUnit(Long subcontractUnit) {
        this.subcontractUnit = subcontractUnit;
    }
    /**
     * 分包单位名称
     */
    public String getSubcontractUnitName() {
        return subcontractUnitName;
    }

    /**
     * 分包单位名称
     */
    public void setSubcontractUnitName(String subcontractUnitName) {
        this.subcontractUnitName = subcontractUnitName;
    }
    /**
     * 除税合价合计
     */
    public java.math.BigDecimal getExcludingTaxTotal() {
        return excludingTaxTotal;
    }

    /**
     * 除税合价合计
     */
    public void setExcludingTaxTotal(java.math.BigDecimal excludingTaxTotal) {
        this.excludingTaxTotal = excludingTaxTotal;
    }
    /**
     * 含税合价合计
     */
    public java.math.BigDecimal getIncludingTaxTotal() {
        return includingTaxTotal;
    }

    /**
     * 含税合价合计
     */
    public void setIncludingTaxTotal(java.math.BigDecimal includingTaxTotal) {
        this.includingTaxTotal = includingTaxTotal;
    }
    /**
     * 除税单价合计
     */
    public java.math.BigDecimal getExcludingTaxUnitPriceTotal() {
        return excludingTaxUnitPriceTotal;
    }

    /**
     * 除税单价合计
     */
    public void setExcludingTaxUnitPriceTotal(java.math.BigDecimal excludingTaxUnitPriceTotal) {
        this.excludingTaxUnitPriceTotal = excludingTaxUnitPriceTotal;
    }
    /**
     * 含税单价合计
     */
    public java.math.BigDecimal getIncludingTaxUnitPriceTotal() {
        return includingTaxUnitPriceTotal;
    }

    /**
     * 含税单价合计
     */
    public void setIncludingTaxUnitPriceTotal(java.math.BigDecimal includingTaxUnitPriceTotal) {
        this.includingTaxUnitPriceTotal = includingTaxUnitPriceTotal;
    }
    /**
     * 分包施工预算图
     */
    public List<SubpackagedetailVO> getSubpackagedetailEntities() {
        return subpackagedetailEntities;
    }

    /**
     * 分包施工预算图
     */
    public void setSubpackagedetailEntities(List<SubpackagedetailVO> subpackagedetailEntities) {
        this.subpackagedetailEntities = subpackagedetailEntities;
    }
}
