/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tools.refer.aspect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ReferFieldControllerAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Around(value="execution(* com.ejianc..controller..query*(..))")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        this.logger.info("\u8fdb\u5165com.ejianc..controller..query*(..)\u5207\u9762");
        Object result = joinPoint.proceed();
        Object processedResult = this.processResult(result);
        this.logger.info("\u5207\u9762com.ejianc..controller..query*(..)\uff0c\u6570\u636e\u5df2\u5904\u7406\uff01");
        System.out.println(JSONObject.toJSONString((Object)result));
        return processedResult;
    }

    private Object processResult(Object result) {
        if (result instanceof CommonResponse) {
            Object data = ((CommonResponse)result).getData();
            if (((CommonResponse)result).isSuccess() && data instanceof BaseVO) {
                Class<?> mainClass = data.getClass();
                Field[] fields = mainClass.getDeclaredFields();
                ArrayList<Field> subFieldsList = new ArrayList<Field>();
                for (Field field2 : fields) {
                    if (field2.isAnnotationPresent(ReferJsonField.class)) {
                        this.setData(field2, mainClass, data);
                    }
                    if (!field2.isAnnotationPresent(SubEntity.class)) continue;
                    subFieldsList.add(field2);
                }
                if (ListUtil.isNotEmpty(subFieldsList)) {
                    subFieldsList.forEach(field -> {
                        String fieldName = field.getName();
                        try {
                            Method m = mainClass.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                            List subList = (List)m.invoke(data, (Object[])null);
                            if (!ListUtil.isEmpty((List)subList)) {
                                for (int i = 0; i < subList.size(); ++i) {
                                    Object s = subList.get(i);
                                    Class<?> subClass = s.getClass();
                                    for (Field f : subClass.getDeclaredFields()) {
                                        if (!f.isAnnotationPresent(ReferJsonField.class)) continue;
                                        this.setData(f, subClass, s);
                                    }
                                }
                            }
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
        return result;
    }

    private void setData(Field field, Class<?> mainClass, Object data) {
        block19: {
            String fieldName = field.getName();
            try {
                String[] referCodeArr;
                String[] ids;
                Method m = mainClass.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                ReferJsonField serialize = field.getAnnotation(ReferJsonField.class);
                String referCode = serialize.referCode();
                String referFields = serialize.referFields();
                String resultFields = serialize.resultFields();
                if (StringUtils.isEmpty((CharSequence)referCode)) {
                    this.logger.error("\u5b57\u6bb5" + fieldName + "\u7684\u6ce8\u89e3@MyJsonSerialize\u53c2\u6570referCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)referFields)) {
                    this.logger.error("\u5b57\u6bb5" + fieldName + "\u7684\u6ce8\u89e3@MyJsonSerialize\u53c2\u6570referFields\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)resultFields)) {
                    this.logger.error("\u5b57\u6bb5" + fieldName + "\u7684\u6ce8\u89e3@MyJsonSerialize\u53c2\u6570resultFields\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    return;
                }
                Object object = m.invoke(data, (Object[])null);
                if (object == null) break block19;
                String value = object.toString();
                String[] stringArray = ids = StringUtils.isBlank((CharSequence)value) ? null : value.split(",");
                if (ids == null || ids.length <= 0) break block19;
                boolean isSingle = ids.length == 1 && !value.contains(",");
                JSONArray jsonArray = null;
                for (String rc : referCodeArr = referCode.split(",")) {
                    try {
                        jsonArray = ReferObjectUtil.getReferEntityValue((String)value, (String)rc);
                    }
                    catch (Exception e) {
                        try {
                            jsonArray = ReferObjectUtil.getReferEntityValue((String)value, (String)rc);
                        }
                        catch (Exception e1) {
                            this.logger.error("referCode:" + rc + " id\uff1a" + value + "\u8f6c\u6362\u51fa\u9519\uff0c--" + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (jsonArray != null && jsonArray.size() > 0) break;
                }
                if (jsonArray != null && jsonArray.size() > 0) {
                    this.logger.info("\u5207\u9762com.ejianc..controller..query*(..)\u8bfb\u53d6\u53c2\u7167--{},\u6570\u636e--{}", (Object)referCode, (Object)JSONObject.toJSONString((Object)jsonArray));
                    if (isSingle) {
                        String[] resultFieldArr;
                        JSONObject referData = jsonArray.getJSONObject(0);
                        String[] referFieldArr = referFields.split(",");
                        if (referFieldArr.length != (resultFieldArr = resultFields.split(",")).length) {
                            this.logger.error("\u5b57\u6bb5" + fieldName + "\u7684\u6ce8\u89e3@MyJsonSerialize\u53c2\u6570referFields\u4e0e\u53c2\u6570resultFields\u5b57\u6bb5\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
                            return;
                        }
                        for (int i = 0; i < referFieldArr.length; ++i) {
                            String referField = referFieldArr[i];
                            String resultField = resultFieldArr[i];
                            Method setMethod = mainClass.getDeclaredMethod("set" + resultField.substring(0, 1).toUpperCase() + resultField.substring(1), String.class);
                            setMethod.invoke(data, referData.getString(referField));
                        }
                    } else {
                        int i;
                        String[] resultFieldArr;
                        String[] referFieldArr = referFields.split(",");
                        if (referFieldArr.length != (resultFieldArr = resultFields.split(",")).length) {
                            this.logger.error("\u5b57\u6bb5" + fieldName + "\u7684\u6ce8\u89e3@MyJsonSerialize\u53c2\u6570referFields\u4e0e\u53c2\u6570resultFields\u5b57\u6bb5\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
                            return;
                        }
                        String[] resultList = new String[referFieldArr.length];
                        for (i = 0; i < jsonArray.size(); ++i) {
                            JSONObject referData = jsonArray.getJSONObject(i);
                            int j = 0;
                            while (j < referFieldArr.length) {
                                String referField = referFieldArr[j];
                                int n = j++;
                                resultList[n] = resultList[n] + referData.getString(referField) + ",";
                            }
                        }
                        for (i = 0; i < referFieldArr.length; ++i) {
                            String resultField = resultFieldArr[i];
                            Method setMethod = mainClass.getDeclaredMethod("set" + resultField.substring(0, 1).toUpperCase() + resultField.substring(1), Object.class);
                            setMethod.invoke(data, resultList[i]);
                        }
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

