package com.ejianc.business.busniessplan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.vo.SubpackageVO;
import com.ejianc.business.busniessplan.vo.SubpackagepackgedetailVO;
import com.ejianc.business.busniessplan.vo.SubpackagesupplydetailVO;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.business.record.vo.RecordsubpackageVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.busniessplan.bean.SubpackageEntity;
import com.ejianc.business.busniessplan.service.ISubpackageService;

/**
 * 分包、分供管理策划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subpackage")
public class SubpackageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "businessplan_subpackage";//此处需要根据实际修改

    @Autowired
    private ISubpackageService service;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackageVO> saveOrUpdate(@RequestBody SubpackageVO saveorUpdateVO) {
        SubpackageEntity entity = BeanMapper.map(saveorUpdateVO, SubpackageEntity.class);
        if(saveorUpdateVO.getId() == null || saveorUpdateVO.getId() == 0){
            //创建条件构造器
            QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.eq("dr", "0");
            List<SubpackageEntity> pro = service.list(queryWrapper);
            if(pro.size() > 0){
                throw new BusinessException("该项目已经创建一个分包、分供管理策划，不允许重复创建!");
            }
            //去除预置内容的虚拟id
            List<SubpackagepackgedetailVO> handleData = saveorUpdateVO.getSubpackagepackgedetailEntities();
            if(handleData != null){
                for (int i = 0; i < handleData.size(); i++) {
                    SubpackagepackgedetailVO subpackagepackgedetailVO = handleData.get(i);
                    subpackagepackgedetailVO.setId(null);
                    handleData.set(i, subpackagepackgedetailVO);
                }

                saveorUpdateVO.setSubpackagepackgedetailEntities(handleData);
            }
        }

    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SubpackageVO vo = BeanMapper.map(entity, SubpackageVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackageVO> queryDetail(Long id) {
    	SubpackageEntity entity = service.selectById(id);
    	SubpackageVO vo = BeanMapper.map(entity, SubpackageVO.class);

        //构建树形结构
        List<SubpackagesupplydetailVO> subpackagesupplydetailVO = vo.getSubpackagesupplydetailEntities();
        List<SubpackagesupplydetailVO> resSubpackagesupplydetailVO = createTreeData(subpackagesupplydetailVO);
        vo.setSubpackagesupplydetailEntities(resSubpackagesupplydetailVO);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordsubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("subpackage_id", vo.getId());
            List<RecordsubpackageEntity> records = recordsubpackageService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordsubpackageList(BeanMapper.mapList(records, RecordsubpackageVO.class));
            }
        }
        
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackageVO> vos) {
        service.removeByIds(vos.stream().map(SubpackageVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubpackageEntity> page = service.queryPage(param,false);
        IPage<SubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubpackageEntity> list = service.queryList(param);
        //时间转换
        List<SubpackageVO> subpackageVOList = BeanMapper.mapList(list, SubpackageVO.class);
        for (int i = 0; i < subpackageVOList.size(); i++) {
            SubpackageVO subpackageVO = subpackageVOList.get(i);
            subpackageVO.setSort(String.valueOf(i+1));
            if (subpackageVO.getCreateTime()!=null){
                subpackageVO.setCreateTimeShow(DateUtils.dateSimple2(subpackageVO.getCreateTime()));
            }

            String billStateStr = subpackageVO.getBillState().toString();
            String changeState = subpackageVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                subpackageVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                subpackageVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", subpackageVOList);
        ExcelExport.getInstance().export("SubpackageMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSubpackageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> refSubpackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackageEntity> page = service.queryPage(param,false);
        IPage<SubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<SubpackagesupplydetailVO> createTreeData(List<SubpackagesupplydetailVO> list) {
        List<SubpackagesupplydetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SubpackagesupplydetailVO> listMap = new HashMap<>();
        for(SubpackagesupplydetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            SubpackagesupplydetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            SubpackagesupplydetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<SubpackagesupplydetailVO> child = (List<SubpackagesupplydetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<SubpackagesupplydetailVO> children = new ArrayList<SubpackagesupplydetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
