package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetdetailEntity;
import com.ejianc.business.busniessplan.service.IMaintargetdetailService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目主要目标导入导出
 */
@Controller
@RequestMapping("maintargetExport")
public class ExcelMaintargetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaintargetdetailService maintargetdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaintarget")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "maintarget-import.xlsx", "商务策划书导入模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaintarget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaintargetdetailVO> successList = new ArrayList<>();
        List<MaintargetdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    MaintargetdetailVO maintargetdetailVO = new MaintargetdetailVO();
                    maintargetdetailVO.setId(IdWorker.getId());//id
                    maintargetdetailVO.setSort(StringUtils.isNotBlank(datas.get(0))?datas.get(0):null); // 目标
                    maintargetdetailVO.setProjectName(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null);
                    maintargetdetailVO.setTarget(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 目标
                    maintargetdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 备注
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        maintargetdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        maintargetdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }*/

                    successList.add(maintargetdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaintargetFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody MaintargetVO maintargetVO, HttpServletResponse response) {
        QueryWrapper<MaintargetdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", maintargetVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaintargetdetailEntity> list = maintargetdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaintargetFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<MaintargetdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }
}
