package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.SubpackagesupplydetailEntity;
import com.ejianc.business.busniessplan.service.ISubpackagesupplydetailService;
import com.ejianc.business.busniessplan.vo.SubpackageVO;
import com.ejianc.business.busniessplan.vo.SubpackagesupplydetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商管理策划表导入导出
 */
@Controller
@RequestMapping("subpackageExport")
public class ExcelSubpackagesupplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubpackagesupplydetailService subpackagesupplydetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSubsupply")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subsupply-import.xlsx", "供应商管理策划表模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubsupply", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SubpackagesupplydetailVO> successList = new ArrayList<>();
        List<SubpackagesupplydetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    SubpackagesupplydetailVO subpackagesupplydetailVO = new SubpackagesupplydetailVO();
                    subpackagesupplydetailVO.setId(IdWorker.getId());//id
                    subpackagesupplydetailVO.setSort(datas.get(0)); // 序号
                    subpackagesupplydetailVO.setManagerContent(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 收支时间(日期)
                    subpackagesupplydetailVO.setManagerAim(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 形象进度节点情况
                    subpackagesupplydetailVO.setManagerMeasures(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 计划完成产值
                    subpackagesupplydetailVO.setPersonLiable(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null); // 土建
                    subpackagesupplydetailVO.setPlanCompleteTime(StringUtils.isNotBlank(datas.get(5))?DateUtils.Date(datas.get(5)):null); // 安装
                    subpackagesupplydetailVO.setImplementationEffect(StringUtils.isNotBlank(datas.get(6))?datas.get(6):null); // 其它

                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        subpackagesupplydetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        subpackagesupplydetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        subpackagesupplydetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        subpackagesupplydetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        subpackagesupplydetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        subpackagesupplydetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        subpackagesupplydetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(subpackagesupplydetailVO);
                        continue;
                    }*/
                    successList.add(subpackagesupplydetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubsupplyFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubsupplyFromDatabase(@RequestBody SubpackageVO subpackageVO, HttpServletResponse response) {
        QueryWrapper<SubpackagesupplydetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackageVO.getId());
        queryWrapper.eq("dr", 0);
        List<SubpackagesupplydetailEntity> list = subpackagesupplydetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subsupply-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubsupplyFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubsupplyFromPage(@RequestBody List<SubpackagesupplydetailVO> list, HttpServletResponse response) {
        for (int i = 0; i < list.size(); i++) {
            SubpackagesupplydetailVO subpackagesupplydetailVO = list.get(i);
            if (subpackagesupplydetailVO.getPlanCompleteTime()!=null){
                subpackagesupplydetailVO.setPlanCompleteTimeShow(DateUtils.dateSimple(subpackagesupplydetailVO.getPlanCompleteTime()));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subsupply-export.xlsx", beans, response);
    }

}
