package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.service.IMaintargetService;
import com.ejianc.business.change.bean.ChangeMaintargetEntity;
import com.ejianc.business.change.mapper.ChangeMaintargetMapper;
import com.ejianc.business.change.service.IChangeMaintargetService;
import com.ejianc.business.change.vo.ChangeMaintargetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 项目主要目标变更
 * 
 * @author generator
 * 
 */
@Service("changeMaintargetService")
public class ChangeMaintargetServiceImpl extends BaseServiceImpl<ChangeMaintargetMapper, ChangeMaintargetEntity> implements IChangeMaintargetService {

    @Autowired
    private IMaintargetService maintargetService;
    @Override
    public CommonResponse<ChangeMaintargetVO> saveChange(ChangeMaintargetVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeMaintargetEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeMaintargetEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeMaintargetEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeMaintargetEntity> queryWrapper = new QueryWrapper<ChangeMaintargetEntity>();
        queryWrapper.eq("maintarget_id", saveOrUpdateVO.getMaintargetId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeMaintargetEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeMaintargetVO vo = BeanMapper.map(entity, ChangeMaintargetVO.class);
        vo.setMaintargetdetailEntities(saveOrUpdateVO.getMaintargetdetailEntities());
        vo.setRecordMaintargetList(saveOrUpdateVO.getRecordMaintargetList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            MaintargetEntity maintargetEntity = maintargetService.selectById(vo.getMaintargetId());
            maintargetEntity.setChangeState("2");//状态改为变更中
            maintargetEntity.setChangeId(vo.getId());
            maintargetService.saveOrUpdate(maintargetEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
