package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CompanyReviewEntity;
import com.ejianc.business.busniessplan.service.ICompanyReviewService;
import com.ejianc.business.change.bean.ChangecompanyreviewEntity;
import com.ejianc.business.change.mapper.ChangecompanyreviewMapper;
import com.ejianc.business.change.service.IChangecompanyreviewService;
import com.ejianc.business.change.vo.ChangecompanyreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 公司评审变更
 * 
 * @author generator
 * 
 */
@Service("changecompanyreviewService")
public class ChangecompanyreviewServiceImpl extends BaseServiceImpl<ChangecompanyreviewMapper, ChangecompanyreviewEntity> implements IChangecompanyreviewService {

    @Autowired
    private ICompanyReviewService companyReviewService;
    @Override
    public CommonResponse<ChangecompanyreviewVO> saveChange(ChangecompanyreviewVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangecompanyreviewEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangecompanyreviewEntity entity = BeanMapper.map(saveOrUpdateVO, ChangecompanyreviewEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangecompanyreviewEntity> queryWrapper = new QueryWrapper<ChangecompanyreviewEntity>();
        queryWrapper.eq("company_review_id", saveOrUpdateVO.getCompanyReviewId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangecompanyreviewEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangecompanyreviewVO vo = BeanMapper.map(entity, ChangecompanyreviewVO.class);
        vo.setRecordcompanyreviewList(saveOrUpdateVO.getRecordcompanyreviewList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            CompanyReviewEntity companyReviewEntity = companyReviewService.selectById(vo.getCompanyReviewId());
            companyReviewEntity.setChangeState("2");//状态改为变更中
            companyReviewEntity.setChangeId(vo.getId());
            companyReviewService.saveOrUpdate(companyReviewEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

}
