/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.excel;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.busniessplan.service.IFundsplanningdetailService;
import com.ejianc.business.busniessplan.vo.FundsplanningVO;
import com.ejianc.business.busniessplan.vo.FundsplanningdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"fundsplanningExport"})
public class ExeclFundsplanningController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFundsplanningdetailService fundsplanningdetailService;
    @Autowired
    private IFundsplanningService service;

    @RequestMapping(value={"/downloadFundsplanning"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"fundsplanning-import.xlsx", (String)"\u9879\u76ee\u8d44\u91d1\u7b56\u5212\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportFundsplanning"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<FundsplanningdetailVO> successList = new ArrayList<FundsplanningdetailVO>();
        ArrayList<FundsplanningdetailVO> errorList = new ArrayList<FundsplanningdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                FundsplanningdetailVO fundsplanningdetailVO = new FundsplanningdetailVO();
                fundsplanningdetailVO.setId(IdWorker.getId());
                fundsplanningdetailVO.setSort((String)datas.get(0));
                fundsplanningdetailVO.setCollectbranchTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? DateUtils.Date((String)datas.get(1)) : null);
                fundsplanningdetailVO.setImagenode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                fundsplanningdetailVO.setPlancomplete(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                fundsplanningdetailVO.setCivilengineering(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : new BigDecimal(0));
                fundsplanningdetailVO.setInstallation(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : new BigDecimal(0));
                fundsplanningdetailVO.setOther(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : new BigDecimal(0));
                if (fundsplanningdetailVO.getCioAmount() == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    fundsplanningdetailVO.setCioAmount(String.valueOf(fundsplanningdetailVO.getOther().add(fundsplanningdetailVO.getCivilengineering()).add(fundsplanningdetailVO.getInstallation())));
                } else {
                    fundsplanningdetailVO.setCioAmount((String)datas.get(7));
                }
                fundsplanningdetailVO.setLabourservices(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : new BigDecimal(0));
                fundsplanningdetailVO.setMaterial(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : new BigDecimal(0));
                fundsplanningdetailVO.setProfessional(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : new BigDecimal(0));
                fundsplanningdetailVO.setOthercost(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : new BigDecimal(0));
                fundsplanningdetailVO.setAnswer(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null);
                fundsplanningdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? (String)datas.get(16) : null);
                fundsplanningdetailVO.setSalary(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : new BigDecimal(0));
                if (fundsplanningdetailVO.getCurrent() == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    BigDecimal currentDec = fundsplanningdetailVO.getLabourservices().add(fundsplanningdetailVO.getMaterial()).add(fundsplanningdetailVO.getProfessional()).add(fundsplanningdetailVO.getOthercost()).add(fundsplanningdetailVO.getSalary());
                    fundsplanningdetailVO.setCurrent(new BigDecimal(fundsplanningdetailVO.getCioAmount()).subtract(currentDec));
                } else {
                    fundsplanningdetailVO.setCurrent(new BigDecimal((String)datas.get(13)));
                }
                if (fundsplanningdetailVO.getCumulative() == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    BigDecimal oldCumulative = new BigDecimal(0);
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"bill_state", (Object)3);
                    queryWrapper.le((Object)"create_time", (Object)DateUtil.now());
                    List fundsplanningEntityList = this.service.list((Wrapper)queryWrapper);
                    for (FundsplanningEntity entity : fundsplanningEntityList) {
                        QueryWrapper wrapper = new QueryWrapper();
                        wrapper.eq((Object)"mid", (Object)entity.getId());
                        List fundsplanningdetailEntityList = this.fundsplanningdetailService.list((Wrapper)wrapper);
                        for (FundsplanningdetailEntity fundsplanningdetailEntity : fundsplanningdetailEntityList) {
                            oldCumulative.add(fundsplanningdetailEntity.getCurrent());
                        }
                    }
                    fundsplanningdetailVO.setCumulative(oldCumulative.add(fundsplanningdetailVO.getCurrent()));
                } else {
                    fundsplanningdetailVO.setCumulative(new BigDecimal((String)datas.get(14)));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    fundsplanningdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(fundsplanningdetailVO);
                    continue;
                }
                successList.add(fundsplanningdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportFundsplanningFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody FundsplanningVO fundsplanningVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)fundsplanningVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.fundsplanningdetailService.list((Wrapper)queryWrapper);
        Integer count = 1;
        for (FundsplanningdetailEntity entity : list) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            entity.setSort(String.valueOf(n));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportFundsplanningFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<FundsplanningdetailVO> list, HttpServletResponse response) {
        for (int i = 0; i < list.size(); ++i) {
            FundsplanningdetailVO fundsplanningdetailVO = list.get(i);
            if (fundsplanningdetailVO.getCollectbranchTime() != null) {
                fundsplanningdetailVO.setCollectbranchTimeShow(DateUtils.dateSimple(fundsplanningdetailVO.getCollectbranchTime()));
            }
            fundsplanningdetailVO.setSort(String.valueOf(i + 1));
        }
        HashMap<String, List<FundsplanningdetailVO>> beans = new HashMap<String, List<FundsplanningdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }
}

