package com.ejianc.business.change.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.change.bean.ChangebusinessplaneffectdetailEntity;
import com.ejianc.business.change.service.IChangebusinessplaneffectdetailService;
import com.ejianc.business.change.vo.ChangebusinessplaneffectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 項目商務策劃效果導入導出
 */
@Controller
@RequestMapping("changeBusinessplanningeffectExport")
public class ExcelChangeBusinessplaneffectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangebusinessplaneffectdetailService changebusinessplaneffectdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadBusinessplanningeffect")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "businessplanningeffect-import.xlsx", "项目商务策划立项清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportBusinessplanningeffect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangebusinessplaneffectdetailVO> successList = new ArrayList<>();
        List<ChangebusinessplaneffectdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=3;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String initiateDate = datas.get(3);//立项时间
                    String costEstimate = datas.get(4);//成本估算(成本分析)(元)
                    String reportAmount = datas.get(5);//上报金额(元)
                    String targetAmount = datas.get(6);//策划目标金额(元)
                    String completeAmount = datas.get(7);//已完成目标金额(元)
                    String estimateProfits = datas.get(8);//预计利润(元)
                    String proposedCompleteTime = datas.get(9);//拟完成时间节点
                    String completeTime = datas.get(10);//完成时间
                    String reportToThismonthProgress = datas.get(12);//报公司截至本月进度(元)
                    String finalCompleteTime = datas.get(15);//(最后)完成时间
                    String supervisionNotReportedMoney = datas.get(17);//（监理单位未上报）金额
                    String supervisionNotReportedTime = datas.get(18);//（监理单位未上报）预计上报时间
                    String supervisionReportedMoney = datas.get(19);//（监理单位已上报未批复）金额
                    String supervisionReportedTime = datas.get(20);//（监理单位已上报未批复）上报时间
                    String supervisionApprovedMoney = datas.get(21);//（监理单位已批复）金额
                    String supervisionApprovedTime = datas.get(22);//（监理单位已批复）上报时间
                    String ownerNotReportedMoney = datas.get(23);//（业主单位未上报）金额
                    String ownerNotReportedTime = datas.get(24);//（业主单位未上报）预计上报时间
                    String ownerReportedMoney = datas.get(25);//（业主单位已上报未批复）金额
                    String ownerReportedTime = datas.get(26);//（业主单位已上报未批复）上报时间
                    String ownerApprovedMoney = datas.get(27);//（业主单位已批复）金额
                    String ownerApprovedTime = datas.get(28);//（业主单位已批复）上报时间
                    String approvedMoney = datas.get(29);//已批复金额
                    String pricedMoney = datas.get(30);//已计价金额
                    String pricedActualMoney = datas.get(31);//已计价部分的实际成本
                    String pricedPartBenefit = datas.get(32);//已计价部分的效益

                    ChangebusinessplaneffectdetailVO businessplanningeffectdetailVO = new ChangebusinessplaneffectdetailVO();
                    businessplanningeffectdetailVO.setId(IdWorker.getId());//id
                    businessplanningeffectdetailVO.setSort(datas.get(0)); // 序号
                    businessplanningeffectdetailVO.setCategoryAndName(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null); // 类别及项目名称
                    businessplanningeffectdetailVO.setInitiateReason(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 立项理由及依据
                    businessplanningeffectdetailVO.setSupportingDetails(StringUtils.isNotBlank(datas.get(11))?datas.get(11):null); // 证明资料明细
                    businessplanningeffectdetailVO.setFirstResponsiblePerson(StringUtils.isNotBlank(datas.get(13))?datas.get(13):null); // 第一责任人
                    businessplanningeffectdetailVO.setMainResponsiblePerson(StringUtils.isNotBlank(datas.get(14))?datas.get(14):null); // 主要负责人
                    businessplanningeffectdetailVO.setAttention(StringUtils.isNotBlank(datas.get(16))?datas.get(16):null); // 推荐情况、存在问题、注意事项
                    businessplanningeffectdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(33))?datas.get(33):null); // 备注

                    //必填项校验
                    if(datas.get(0)==null || datas.get(0) == ""){
                        businessplanningeffectdetailVO.setErrorMsg("序号不能为空");
                        errorsMsgBuilder.append("序号不能为空");
                    }else{
                        businessplanningeffectdetailVO.setSort(datas.get(0));
                    }
                    if(datas.get(1) == null || StringUtils.isBlank(datas.get(1))){
                        businessplanningeffectdetailVO.setErrorMsg("类别及项目名称不能为空");
                        errorsMsgBuilder.append("类别及项目名称不能为空");
                    }else{
                        businessplanningeffectdetailVO.setCategoryAndName(datas.get(1));
                    }

                    //格式校验
                    if(StringUtils.isNotBlank(initiateDate)){
                        if(DateUtils.grepDate(initiateDate)){
                            businessplanningeffectdetailVO.setInitiateDate(DateUtils.Date(initiateDate));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("立项时间格式不正确！");
                            errorsMsgBuilder.append("立项时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(costEstimate)){
                        if(NumberUtil.isNumber(costEstimate)){
                            businessplanningeffectdetailVO.setCostEstimate(new BigDecimal(costEstimate));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("成本估算(成本分析)(元)格式不正确！");
                            errorsMsgBuilder.append("成本估算(成本分析)(元)格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(reportAmount)){
                        if(NumberUtil.isNumber(reportAmount)){
                            businessplanningeffectdetailVO.setReportAmount(new BigDecimal(reportAmount));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("上报金额(元)格式不正确！");
                            errorsMsgBuilder.append("上报金额(元)格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(targetAmount)){
                        if(NumberUtil.isNumber(targetAmount)){
                            businessplanningeffectdetailVO.setTargetAmount(new BigDecimal(targetAmount));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("策划目标金额(元)格式不正确！");
                            errorsMsgBuilder.append("策划目标金额(元)格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(completeAmount)){
                        if(NumberUtil.isNumber(completeAmount)){
                            businessplanningeffectdetailVO.setCompleteAmount(new BigDecimal(completeAmount));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("已完成目标金额(元)格式不正确！");
                            errorsMsgBuilder.append("已完成目标金额(元)格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(estimateProfits)){
                        if(NumberUtil.isNumber(estimateProfits)){
                            businessplanningeffectdetailVO.setEstimateProfits(new BigDecimal(estimateProfits));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("预计利润(元)格式不正确！");
                            errorsMsgBuilder.append("预计利润(元)格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(proposedCompleteTime)){
                        if(DateUtils.grepDate(proposedCompleteTime)){
                            businessplanningeffectdetailVO.setProposedCompleteTime(DateUtils.Date(proposedCompleteTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("拟完成时间节点格式不正确！");
                            errorsMsgBuilder.append("拟完成时间节点格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(completeTime)){
                        if(DateUtils.grepDate(completeTime)){
                            businessplanningeffectdetailVO.setCompleteTime(DateUtils.Date(completeTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("完成时间格式不正确！");
                            errorsMsgBuilder.append("完成时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(reportToThismonthProgress)){
                        if(NumberUtil.isNumber(reportToThismonthProgress)){
                            businessplanningeffectdetailVO.setReportToThismonthProgress(new BigDecimal(reportToThismonthProgress));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("报公司截至本月进度(元)格式不正确！");
                            errorsMsgBuilder.append("报公司截至本月进度(元)格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(finalCompleteTime)){
                        if(DateUtils.grepDate(finalCompleteTime)){
                            businessplanningeffectdetailVO.setFinalCompleteTime(DateUtils.Date(finalCompleteTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("(最后)完成时间格式不正确！");
                            errorsMsgBuilder.append("(最后)完成时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(supervisionNotReportedMoney)){
                        if(NumberUtil.isNumber(supervisionNotReportedMoney)){
                            businessplanningeffectdetailVO.setSupervisionNotReportedMoney(new BigDecimal(supervisionNotReportedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位未上报）金额格式不正确！");
                            errorsMsgBuilder.append("（监理单位未上报）金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(supervisionNotReportedTime)){
                        if(DateUtils.grepDate(supervisionNotReportedTime)){
                            businessplanningeffectdetailVO.setSupervisionNotReportedTime(DateUtils.Date(supervisionNotReportedTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位未上报）预计上报时间格式不正确！");
                            errorsMsgBuilder.append("（监理单位未上报）预计上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(supervisionReportedMoney)){
                        if(NumberUtil.isNumber(supervisionReportedMoney)){
                            businessplanningeffectdetailVO.setSupervisionReportedMoney(new BigDecimal(supervisionReportedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已上报未批复）金额格式不正确！");
                            errorsMsgBuilder.append("（监理单位已上报未批复）金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(supervisionReportedTime)){
                        if(DateUtils.grepDate(supervisionReportedTime)){
                            businessplanningeffectdetailVO.setSupervisionReportedTime(DateUtils.Date(supervisionReportedTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已上报未批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("（监理单位已上报未批复）上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(supervisionApprovedMoney)){
                        if(NumberUtil.isNumber(supervisionApprovedMoney)){
                            businessplanningeffectdetailVO.setSupervisionApprovedMoney(new BigDecimal(supervisionApprovedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已批复）金额格式不正确！");
                            errorsMsgBuilder.append("（监理单位已批复）金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(supervisionApprovedTime)){
                        if(DateUtils.grepDate(supervisionApprovedTime)){
                            businessplanningeffectdetailVO.setSupervisionApprovedTime(DateUtils.Date(supervisionApprovedTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("（监理单位已批复）上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(ownerNotReportedMoney)){
                        if(NumberUtil.isNumber(ownerNotReportedMoney)){
                            businessplanningeffectdetailVO.setOwnerNotReportedMoney(new BigDecimal(ownerNotReportedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位未上报）金额格式不正确！");
                            errorsMsgBuilder.append("（业主单位未上报）金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(ownerNotReportedTime)){
                        if(DateUtils.grepDate(ownerNotReportedTime)){
                            businessplanningeffectdetailVO.setOwnerNotReportedTime(DateUtils.Date(ownerNotReportedTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位未上报）预计上报时间格式不正确！");
                            errorsMsgBuilder.append("（业主单位未上报）预计上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(ownerReportedMoney)){
                        if(NumberUtil.isNumber(ownerReportedMoney)){
                            businessplanningeffectdetailVO.setOwnerReportedMoney(new BigDecimal(ownerReportedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位已上报未批复）金额格式不正确！");
                            errorsMsgBuilder.append("（业主单位已上报未批复）金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(ownerReportedTime)){
                        if(DateUtils.grepDate(ownerReportedTime)){
                            businessplanningeffectdetailVO.setOwnerReportedTime(DateUtils.Date(ownerReportedTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("业主单位已上报未批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("业主单位已上报未批复）上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(ownerApprovedMoney)){
                        if(NumberUtil.isNumber(ownerApprovedMoney)){
                            businessplanningeffectdetailVO.setOwnerApprovedMoney(new BigDecimal(ownerApprovedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位已批复）金额格式不正确！");
                            errorsMsgBuilder.append("（业主单位已批复）金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(ownerApprovedTime)){
                        if(DateUtils.grepDate(ownerApprovedTime)){
                            businessplanningeffectdetailVO.setOwnerApprovedTime(DateUtils.Date(ownerApprovedTime));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位已批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("（业主单位已批复）上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(approvedMoney)){
                        if(NumberUtil.isNumber(approvedMoney)){
                            businessplanningeffectdetailVO.setApprovedMoney(new BigDecimal(approvedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("已批复金额格式不正确！");
                            errorsMsgBuilder.append("已批复金额格式不正确！");
                        }
                    }else {
                        //为空则自动计算: 监理单位已批复金额+业主单位已批复金额
                        BigDecimal approvedMoneyB = new BigDecimal(0);
                        BigDecimal supervisionApprovedMoneyB = businessplanningeffectdetailVO.getSupervisionApprovedMoney();
                        BigDecimal ownerApprovedMoneyB = businessplanningeffectdetailVO.getOwnerApprovedMoney();
                        if(supervisionApprovedMoneyB != null){
                            approvedMoneyB = approvedMoneyB.add(supervisionApprovedMoneyB);
                            businessplanningeffectdetailVO.setApprovedMoney(approvedMoneyB);
                        }

                        if(ownerApprovedMoneyB != null){
                            approvedMoneyB = approvedMoneyB.add(ownerApprovedMoneyB);
                            businessplanningeffectdetailVO.setApprovedMoney(approvedMoneyB);
                        }
                    }

                    if(StringUtils.isNotBlank(pricedMoney)){
                        if(NumberUtil.isNumber(pricedMoney)){
                            businessplanningeffectdetailVO.setPricedMoney(new BigDecimal(pricedMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("已计价金额格式不正确！");
                            errorsMsgBuilder.append("已计价金额格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(pricedActualMoney)){
                        if(NumberUtil.isNumber(pricedActualMoney)){
                            businessplanningeffectdetailVO.setPricedActualMoney(new BigDecimal(pricedActualMoney));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("已计价部分的实际成本格式不正确！");
                            errorsMsgBuilder.append("已计价部分的实际成本格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(pricedPartBenefit)){
                        if(NumberUtil.isNumber(pricedPartBenefit)){
                            businessplanningeffectdetailVO.setPricedPartBenefit(new BigDecimal(pricedPartBenefit));
                        }else {
                            businessplanningeffectdetailVO.setErrorMsg("已计价部分的效益格式不正确！");
                            errorsMsgBuilder.append("已计价部分的效益格式不正确！");
                        }
                    }else {
                        //为空则自动计算:已计价金额-已计价部分实际成本
                        BigDecimal pricedPartBenefitB = new BigDecimal(0);
                        BigDecimal pricedMoneyB = businessplanningeffectdetailVO.getPricedMoney();
                        BigDecimal pricedActualMoneyB = businessplanningeffectdetailVO.getPricedActualMoney();
                        if(pricedMoneyB != null){
                            pricedPartBenefitB = pricedMoneyB;
                            businessplanningeffectdetailVO.setPricedPartBenefit(pricedPartBenefitB);
                        }

                        if(pricedActualMoneyB != null){
                            pricedPartBenefitB = pricedMoneyB.subtract(pricedActualMoneyB);
                            businessplanningeffectdetailVO.setPricedPartBenefit(pricedPartBenefitB);
                        }
                    }

                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(businessplanningeffectdetailVO);
                    } else {
                        successList.add(businessplanningeffectdetailVO);
                    }
                }
            }
        }
        //设置tid和tpid
        List<ChangebusinessplaneffectdetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     * @param originalList
     * @return
     */
    private List<ChangebusinessplaneffectdetailVO> setTidAndTpid(List<ChangebusinessplaneffectdetailVO> originalList) {
        List<ChangebusinessplaneffectdetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = originalList.get(i);
                String sort = changebusinessplaneffectdetailVO.getSort();
                String[] arr = sort.split("\\.");

                if (arr.length == 1) {
                    changebusinessplaneffectdetailVO.setTid(currentTime + "_" + sort);
                    changebusinessplaneffectdetailVO.setTpid("");
                    changebusinessplaneffectdetailVO.setShadowId(currentTime + "_" + sort);
                    treeList.add(changebusinessplaneffectdetailVO);
                } else if (arr.length > 1) {
                    changebusinessplaneffectdetailVO.setTid(currentTime + "_" + sort);
                    changebusinessplaneffectdetailVO.setShadowId(currentTime + "_" + sort);
                    changebusinessplaneffectdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                    treeList.add(changebusinessplaneffectdetailVO);
                }
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     * @param list
     * @return
     */
    public static List<ChangebusinessplaneffectdetailVO> createTreeData(List<ChangebusinessplaneffectdetailVO> list) {
        List<ChangebusinessplaneffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangebusinessplaneffectdetailVO> listMap = new HashMap<>();
        for (ChangebusinessplaneffectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangebusinessplaneffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangebusinessplaneffectdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangebusinessplaneffectdetailVO> child = (List<ChangebusinessplaneffectdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangebusinessplaneffectdetailVO> children = new ArrayList<ChangebusinessplaneffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO, HttpServletResponse response) {
        QueryWrapper<ChangebusinessplaneffectdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changebusinessplaneffectdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangebusinessplaneffectdetailEntity> list = changebusinessplaneffectdetailService.list(queryWrapper);
        List<ChangebusinessplaneffectdetailVO> resList = BeanMapper.mapList(list, ChangebusinessplaneffectdetailVO.class);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(resList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<ChangebusinessplaneffectdetailVO> list, HttpServletResponse response) {
        List<ChangebusinessplaneffectdetailVO> concatList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = list.get(i);
            concatList.add(changebusinessplaneffectdetailVO);
        }

        //children拍平
        List<ChangebusinessplaneffectdetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<ChangebusinessplaneffectdetailVO>() {
            @Override
            public int compare(ChangebusinessplaneffectdetailVO o1, ChangebusinessplaneffectdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(allList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * 处理特殊字段 如：日期
     * @param allList
     */
    private List<ChangebusinessplaneffectdetailVO> handleSpecialField(List<ChangebusinessplaneffectdetailVO> allList) {
        //处理日期字段
        for (int i = 0; i < allList.size(); i++) {
            ChangebusinessplaneffectdetailVO businessplanningeffectdetailVO = allList.get(i);
            if (businessplanningeffectdetailVO.getCompleteTime()!=null){
                businessplanningeffectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getInitiateDate()!=null){
                businessplanningeffectdetailVO.setLxDateShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getInitiateDate()));
            }
            if (businessplanningeffectdetailVO.getProposedCompleteTime()!=null){
                businessplanningeffectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getProposedCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getFinalCompleteTime()!=null){
                businessplanningeffectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getFinalCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionNotReportedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionReportedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionApprovedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionApprovedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerNotReportedTime()!=null){
                businessplanningeffectdetailVO.setOwnerNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerReportedTime()!=null){
                businessplanningeffectdetailVO.setOwnerReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerApprovedTime()!=null){
                businessplanningeffectdetailVO.setOwnerApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerApprovedTime()));
            }
        }

        return allList;
    }

    /**
     * 导出页面数据处理children
     * @param list
     */
    private List<ChangebusinessplaneffectdetailVO> handleList(List<ChangebusinessplaneffectdetailVO> list, List<ChangebusinessplaneffectdetailVO> concatList) {
        if(list == null || list.size() == 0){
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = list.get(i);
            List<ChangebusinessplaneffectdetailVO> children = changebusinessplaneffectdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
