package com.ejianc.business.busniessplan.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.busniessplan.service.IFundsplanningdetailService;
import com.ejianc.business.busniessplan.vo.FundsplanningVO;
import com.ejianc.business.busniessplan.vo.FundsplanningdetailVO;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.record.bean.RecordFundsplanningEntity;
import com.ejianc.business.record.service.IRecordFundsplanningService;
import com.ejianc.business.record.vo.RecordFundsplanningVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目资金管理策划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fundsplanning")
public class FundsplanningController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "busniessplan-fundsplan";//此处需要根据实际修改

    @Autowired
    private IFundsplanningService service;

    @Autowired
    private IFundsplanningdetailService fundsplanningdetailService;

    @Autowired
    private IRecordFundsplanningService recordFundsplanningService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FundsplanningVO> saveOrUpdate(@RequestBody FundsplanningVO saveorUpdateVO) {
    	FundsplanningEntity entity = BeanMapper.map(saveorUpdateVO, FundsplanningEntity.class);
        entity.setChangeState("1");
        FundsplanningEntity fundsplanningEntity = checkBillCodeUniq(entity);
        service.saveOrUpdate(fundsplanningEntity, false);
    	FundsplanningVO vo = BeanMapper.map(fundsplanningEntity, FundsplanningVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private FundsplanningEntity checkBillCodeUniq(FundsplanningEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<FundsplanningEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<FundsplanningEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    FundsplanningEntity fundsplanningEntityCode = proBillCode.get(i);
                    if(!fundsplanningEntityCode.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }
        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FundsplanningVO> queryDetail(Long id) {
    	FundsplanningEntity entity = service.selectById(id);
    	FundsplanningVO vo = BeanMapper.map(entity, FundsplanningVO.class);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordFundsplanningEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("fundsplanning_id", id);

            List<RecordFundsplanningEntity> records = recordFundsplanningService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordFundsplanningList(BeanMapper.mapList(records, RecordFundsplanningVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FundsplanningVO> vos) {
        service.removeByIds(vos.stream().map(FundsplanningVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FundsplanningVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        IPage<FundsplanningEntity> page = service.queryPage(param,false);
        IPage<FundsplanningVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FundsplanningVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<FundsplanningEntity> list = service.queryList(param);
        //时间转换
        List<FundsplanningVO> fundsplanningVOList = BeanMapper.mapList(list, FundsplanningVO.class);
        for (int i = 0; i < fundsplanningVOList.size(); i++) {
            FundsplanningVO fundsplanningVO = fundsplanningVOList.get(i);
            fundsplanningVO.setSort(String.valueOf(i+1));
            if (fundsplanningVO.getCreateTime()!=null){
                fundsplanningVO.setCreateTimeShow(DateUtils.dateSimple2(fundsplanningVO.getCreateTime()));
            }

            String billStateStr = fundsplanningVO.getBillState().toString();
            String changeState = fundsplanningVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                fundsplanningVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                fundsplanningVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", fundsplanningVOList);
        ExcelExport.getInstance().export("FundsplanningMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFundsplanningData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FundsplanningVO>> refFundsplanningData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FundsplanningEntity> page = service.queryPage(param,false);
        IPage<FundsplanningVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FundsplanningVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/selectPrevious", method = RequestMethod.GET)
    @ResponseBody
     public CommonResponse selectPrevious(String projectId){
         QueryWrapper<FundsplanningEntity> queryWrapper = new QueryWrapper<>();
         queryWrapper.in("bill_state",1,3);
         queryWrapper.eq("project_id",projectId);
         queryWrapper.eq("dr",0);
         queryWrapper.lt("create_time", DateUtil.now());
         List<FundsplanningEntity> fundsplanningEntityList = service.list(queryWrapper);

        BigDecimal decimal = new BigDecimal(0);

        for (FundsplanningEntity entity : fundsplanningEntityList) {
             QueryWrapper<FundsplanningdetailEntity> wrapper = new QueryWrapper<>();
             wrapper.eq("mid",entity.getId());
             queryWrapper.eq("dr",0);
             List<FundsplanningdetailEntity> fundsplanningdetailEntityList = fundsplanningdetailService.list(wrapper);
             for (FundsplanningdetailEntity fundsplanningdetailEntity : fundsplanningdetailEntityList) {
                 BigDecimal current = fundsplanningdetailEntity.getCurrent();
                 decimal = decimal.add(current);
             }
         }
         return CommonResponse.success(decimal);

     }
     //新增查询带入上次单据数据
//    @RequestMapping(value = "/queryFundsplan", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<FundsplanningVO> queryPlan(Long projectId) {
//        QueryWrapper<FundsplanningEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("dr", 0);
//        queryWrapper.eq("project_id", projectId);
//        queryWrapper.in("bill_state", "1","3");
//        List<FundsplanningEntity> entityList = service.list(queryWrapper);
//
//        QueryWrapper<FundsplanningdetailEntity> queryWrapper1 = new QueryWrapper<>();
//        queryWrapper1.eq("dr", 0);
//        queryWrapper1.eq("mid", entityList.get(0).getId());
//        List<FundsplanningdetailEntity> list = fundsplanningdetailService.list(queryWrapper1);
//        entityList.get(0).setFundsplanningdetailEntities(list);
//        FundsplanningVO entity = BeanMapper.map(entityList.get(0), FundsplanningVO.class);
//        List<FundsplanningdetailVO> fundsplanningdetailEntities = entity.getFundsplanningdetailEntities();
//        //List<FundsplanningdetailVO> treeData = createTreeData1(fundsplanningdetailEntities);
//        entity.setFundsplanningdetailEntities(fundsplanningdetailEntities);
//        return CommonResponse.success("查询成功！", entity);
//    }

}
