package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.service.IProjoverviewService;
import com.ejianc.business.busniessplan.vo.ProjectcontractVO;
import com.ejianc.business.busniessplan.vo.ProjectdetailVO;
import com.ejianc.business.busniessplan.vo.ProjoverviewVO;
import com.ejianc.business.change.bean.ChangeProjoverviewEntity;
import com.ejianc.business.change.service.IChangeProjoverviewService;
import com.ejianc.business.change.vo.ChangeProjoverviewVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 工程概述变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeProjoverview")
public class ChangeProjoverviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangeProjoverviewService service;
    @Autowired
    private IProjoverviewService projoverviewService;

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailByProjoverviewId")
    @ResponseBody
    public CommonResponse<ChangeProjoverviewVO> queryDetailByProjoverviewId(@RequestParam(value = "projoverviewId") Long projoverviewId) {
        ProjoverviewEntity projoverviewVO = projoverviewService.selectById(projoverviewId);
        ChangeProjoverviewVO changeVO = BeanMapper.map(projoverviewVO, ChangeProjoverviewVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(projoverviewId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        List<ProjectdetailVO> list = new ArrayList<>();
        ProjectdetailVO projectdetailVO = new ProjectdetailVO();
        projectdetailVO.setProjectBidWinPrice(projoverviewVO.getProjectBidWinPrice());
        projectdetailVO.setCivilEngineering(projoverviewVO.getCivilEngineering());
        projectdetailVO.setFix(projoverviewVO.getFix());
        projectdetailVO.setWaterSupplyDrainage(projoverviewVO.getWaterSupplyDrainage());
        projectdetailVO.setStrongCurrent(projoverviewVO.getStrongCurrent());
        projectdetailVO.setHeateVentilation(projoverviewVO.getHeateVentilation());
        projectdetailVO.setFixOther(projoverviewVO.getFixOther());
        projectdetailVO.setDecorate(projoverviewVO.getDecorate());
        projectdetailVO.setOther(projoverviewVO.getOther());
        list.add(projectdetailVO);
        changeVO.setProjectdetailList(list);

        List<ProjectcontractVO> clist = new ArrayList<>();
        ProjectcontractVO projectcontractVO = new ProjectcontractVO();
        projectcontractVO.setContractAmount(projoverviewVO.getContractAmount());
        projectcontractVO.setSelfConstructionContractAmount(projoverviewVO.getSelfConstructionContractAmount());
        projectcontractVO.setBelong(projoverviewVO.getBelong());
        clist.add(projectcontractVO);
        changeVO.setProjectcontractList(clist);


        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeProjoverviewVO> saveOrUpdate(@RequestBody ChangeProjoverviewVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeProjoverviewVO> queryDetail(Long id) {
    	ChangeProjoverviewEntity entity = service.selectById(id);
    	ChangeProjoverviewVO vo = BeanMapper.map(entity, ChangeProjoverviewVO.class);

        List<ProjectdetailVO> ProjectdetailList = new ArrayList<>();
        ProjectdetailVO ProjectdetailVO = BeanMapper.map(entity, ProjectdetailVO.class);
        ProjectdetailVO.setRowState("add");
        ProjectdetailList.add(ProjectdetailVO);
        vo.setProjectdetailList(ProjectdetailList);

        List<ProjectcontractVO> ProjectcontractList = new ArrayList<>();
        ProjectcontractVO projectcontractVO = BeanMapper.map(entity, ProjectcontractVO.class);
        projectcontractVO.setRowState("add");
        ProjectcontractList.add(projectcontractVO);
        vo.setProjectcontractList(ProjectcontractList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjoverviewVO> vos) {
        return service.deleteProjoverview(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeProjoverviewVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeProjoverviewEntity> page = service.queryPage(param,false);
        IPage<ChangeProjoverviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeProjoverviewVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeProjoverviewEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangeProjoverview-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangeProjoverviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeProjoverviewVO>> refChangeProjoverviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeProjoverviewEntity> page = service.queryPage(param,false);
        IPage<ChangeProjoverviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeProjoverviewVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
