/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.busniessplan.service.IFundsplanningdetailService;
import com.ejianc.business.busniessplan.vo.FundsplanningVO;
import com.ejianc.business.busniessplan.vo.FundsplanningdetailVO;
import com.ejianc.business.record.service.IRecordFundsplanningService;
import com.ejianc.business.record.vo.RecordFundsplanningVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fundsplanning"})
public class FundsplanningController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "busniessplan-fundsplan";
    @Autowired
    private IFundsplanningService service;
    @Autowired
    private IFundsplanningdetailService fundsplanningdetailService;
    @Autowired
    private IRecordFundsplanningService recordFundsplanningService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FundsplanningVO> saveOrUpdate(@RequestBody FundsplanningVO saveorUpdateVO) {
        FundsplanningEntity entity = (FundsplanningEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), FundsplanningEntity.class));
        entity.setChangeState("1");
        FundsplanningEntity fundsplanningEntity = this.checkBillCodeUniq(entity);
        this.service.saveOrUpdate((Object)fundsplanningEntity, false);
        FundsplanningVO vo = (FundsplanningVO)((Object)BeanMapper.map((Object)((Object)fundsplanningEntity), FundsplanningVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FundsplanningEntity checkBillCodeUniq(FundsplanningEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            List proBillCode = this.service.list((Wrapper)queryWrapperBillCode);
            if (proBillCode == null || proBillCode.size() <= 0) return entity;
            for (int i = 0; i < proBillCode.size(); ++i) {
                FundsplanningEntity fundsplanningEntityCode = (FundsplanningEntity)((Object)proBillCode.get(i));
                if (fundsplanningEntityCode.getId().equals(entity.getId())) continue;
                throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
            }
        }
        return entity;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FundsplanningVO> queryDetail(Long id) {
        FundsplanningEntity entity = (FundsplanningEntity)((Object)this.service.selectById(id));
        FundsplanningVO vo = (FundsplanningVO)((Object)BeanMapper.map((Object)((Object)entity), FundsplanningVO.class));
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"fundsplanning_id", (Object)id);
            List records = this.recordFundsplanningService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordFundsplanningList(BeanMapper.mapList((Iterable)records, RecordFundsplanningVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FundsplanningVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FundsplanningVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FundsplanningVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List fundsplanningVOList = BeanMapper.mapList((Iterable)list, FundsplanningVO.class);
        for (int i = 0; i < fundsplanningVOList.size(); ++i) {
            FundsplanningVO fundsplanningVO = (FundsplanningVO)((Object)fundsplanningVOList.get(i));
            fundsplanningVO.setSort(String.valueOf(i + 1));
            if (fundsplanningVO.getCreateTime() != null) {
                fundsplanningVO.setCreateTimeShow(DateUtils.dateSimple2(fundsplanningVO.getCreateTime()));
            }
            String billStateStr = fundsplanningVO.getBillState().toString();
            String changeState = fundsplanningVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                fundsplanningVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            fundsplanningVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", fundsplanningVOList);
        ExcelExport.getInstance().export("FundsplanningMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFundsplanningData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FundsplanningVO>> refFundsplanningData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FundsplanningVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectPrevious"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse selectPrevious(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.lt((Object)"create_time", (Object)DateUtil.now());
        List fundsplanningEntityList = this.service.list((Wrapper)queryWrapper);
        BigDecimal decimal = new BigDecimal(0);
        for (FundsplanningEntity entity : fundsplanningEntityList) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"mid", (Object)entity.getId());
            queryWrapper.eq((Object)"dr", (Object)0);
            List fundsplanningdetailEntityList = this.fundsplanningdetailService.list((Wrapper)wrapper);
            for (FundsplanningdetailEntity fundsplanningdetailEntity : fundsplanningdetailEntityList) {
                BigDecimal cumulative = fundsplanningdetailEntity.getCumulative();
                if (cumulative == null) continue;
                decimal = decimal.add(cumulative);
            }
        }
        return CommonResponse.success((Object)decimal);
    }

    @RequestMapping(value={"/queryFundsplan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FundsplanningVO> queryPlan(Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", new Object[]{"1", "3"});
        List entityList = this.service.list((Wrapper)queryWrapper);
        if (entityList != null && entityList.size() > 0) {
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"dr", (Object)0);
            queryWrapper1.eq((Object)"mid", (Object)((FundsplanningEntity)((Object)entityList.get(0))).getId());
            List list = this.fundsplanningdetailService.list((Wrapper)queryWrapper1);
            ((FundsplanningEntity)((Object)entityList.get(0))).setFundsplanningdetailEntities(list);
            FundsplanningVO entity = (FundsplanningVO)((Object)BeanMapper.map(entityList.get(0), FundsplanningVO.class));
            List<FundsplanningdetailVO> fundsplanningdetailEntities = entity.getFundsplanningdetailEntities();
            entity.setFundsplanningdetailEntities(fundsplanningdetailEntities);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((Object)entity));
        }
        return CommonResponse.success((String)"cc\u6210\u529f\uff01");
    }
}

