package com.ejianc.business.change.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.*;
import com.ejianc.business.busniessplan.service.*;
import com.ejianc.business.busniessplan.vo.CountersignatureVO;
import com.ejianc.business.change.bean.ChangecountersignatureEntity;
import com.ejianc.business.change.service.IChangecountersignatureService;
import com.ejianc.business.change.vo.ChangecountersignatureVO;
import com.ejianc.business.change.vo.ChangecountersignaturedetailVO;
import com.ejianc.business.record.service.IRecordcountersignatureService;
import com.ejianc.foundation.honouragreement.api.IHonouragreementApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 商务会签变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changecountersignature")
public class ChangecountersignatureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangecountersignatureService service;
    @Autowired
    private ICountersignatureService countersignatureService;


    @Autowired
    private IRecordcountersignatureService recordcountersignatureService;

    @Autowired
    private IProjoverviewService projoverviewService;
    @Autowired
    private IOrgstructureService orgstructureService;
    @Autowired
    private IMaintargetService maintargetService;
    @Autowired
    private IPlanprojectService planprojectService;
    @Autowired
    private IFundrecoveryplanService fundrecoveryplanService;
    @Autowired
    private IFundsplanningService fundsplanningService;
    @Autowired
    private IBusinessplanningeffectService businessplanningeffectService;
    @Autowired
    private ISubpackageService subpackageService;

    @Autowired
    IHonouragreementApi honouragreementApi;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByCountersignatureId")
    @ResponseBody
    public CommonResponse<ChangecountersignatureVO> queryDetailByCountersignatureId(@RequestParam(value = "countersignatureId") Long countersignatureId) {
        CountersignatureEntity quotaanalysisVO = countersignatureService.selectById(countersignatureId);
        ChangecountersignatureVO changeVO = BeanMapper.map(quotaanalysisVO, ChangecountersignatureVO.class);
        Long id = IdWorker.getId();
        changeVO.setCountersignatureId(countersignatureId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);
        List<ChangecountersignaturedetailVO> resList = new ArrayList<>();

        Long projectId = quotaanalysisVO.getProjectId();
        //1.工程概述
        QueryWrapper<ProjoverviewEntity> queryWrapperProjoverview = new QueryWrapper<>();
        queryWrapperProjoverview.eq("dr", 0);
        queryWrapperProjoverview.eq("project_id", projectId);
        queryWrapperProjoverview.in("bill_state", "1","3");
        List<ProjoverviewEntity> projoverviewList = projoverviewService.list(queryWrapperProjoverview);

        ChangecountersignaturedetailVO resVO1 = new ChangecountersignaturedetailVO();
        resVO1.setId(IdWorker.getId());
        if(projoverviewList != null && projoverviewList.size() > 0){
            ProjoverviewEntity projoverviewEntity = projoverviewList.get(0);
            resVO1.setLinkBillId(projoverviewEntity.getId());
            resVO1.setLinkBillCode(projoverviewEntity.getBillCode());
        }
        resVO1.setLinkBillName("工程概述");
        resList.add(resVO1);

        //2.项目商务组织架构
        QueryWrapper<OrgstructureEntity> queryWrapperOrgstructure = new QueryWrapper<>();
        queryWrapperOrgstructure.eq("dr", 0);
        queryWrapperOrgstructure.eq("project_id", projectId);
        queryWrapperOrgstructure.in("bill_state", "1","3");
        List<OrgstructureEntity> orgstructureList = orgstructureService.list(queryWrapperOrgstructure);
        ChangecountersignaturedetailVO resVO2 = new ChangecountersignaturedetailVO();
        resVO2.setId(IdWorker.getId());
        if(orgstructureList != null && orgstructureList.size() > 0){
            OrgstructureEntity orgstructureEntity = orgstructureList.get(0);
            resVO2.setLinkBillId(orgstructureEntity.getId());
            resVO2.setLinkBillCode(orgstructureEntity.getBillCode());
        }
        resVO2.setLinkBillName("项目商务组织架构");
        resList.add(resVO2);

        //3.项目主要管理目标
        QueryWrapper<MaintargetEntity> queryWrapperMaintarget = new QueryWrapper<>();
        queryWrapperMaintarget.eq("dr", 0);
        queryWrapperMaintarget.eq("project_id", projectId);
        queryWrapperMaintarget.in("bill_state", "1","3");
        List<MaintargetEntity> maintargetList = maintargetService.list(queryWrapperMaintarget);

        ChangecountersignaturedetailVO resVO3 = new ChangecountersignaturedetailVO();
        resVO3.setId(IdWorker.getId());
        if(maintargetList != null && maintargetList.size() > 0){
            MaintargetEntity maintargetEntity = maintargetList.get(0);
            resVO3.setLinkBillId(maintargetEntity.getId());
            resVO3.setLinkBillCode(maintargetEntity.getBillCode());
        }
        resVO3.setLinkBillName("项目主要管理目标");
        resList.add(resVO3);

        //4.项目商务策划立项
        QueryWrapper<PlanprojectEntity> queryWrapperPlanproject = new QueryWrapper<>();
        queryWrapperPlanproject.eq("dr", 0);
        queryWrapperPlanproject.eq("project_id", projectId);
        queryWrapperPlanproject.in("bill_state", "1","3");
        List<PlanprojectEntity> planprojectList = planprojectService.list(queryWrapperPlanproject);

        ChangecountersignaturedetailVO resVO4 = new ChangecountersignaturedetailVO();
        resVO4.setId(IdWorker.getId());
        if(planprojectList != null && planprojectList.size() > 0){
            PlanprojectEntity planprojectEntity = planprojectList.get(0);
            resVO4.setLinkBillId(planprojectEntity.getId());
            resVO4.setLinkBillCode(planprojectEntity.getBillCode());
        }
        resVO4.setLinkBillName("项目商务策划立项");
        resList.add(resVO4);

        //5.项目资金回收流程策划
        QueryWrapper<FundrecoveryplanEntity> queryWrapperFundrecoveryplan = new QueryWrapper<>();
        queryWrapperFundrecoveryplan.eq("dr", 0);
        queryWrapperFundrecoveryplan.eq("project_id", projectId);
        queryWrapperFundrecoveryplan.in("bill_state", "1","3");
        List<FundrecoveryplanEntity> fundrecoveryplanList = fundrecoveryplanService.list(queryWrapperFundrecoveryplan);

        ChangecountersignaturedetailVO resVO5 = new ChangecountersignaturedetailVO();
        resVO5.setId(IdWorker.getId());
        if(fundrecoveryplanList != null && fundrecoveryplanList.size() > 0){
            FundrecoveryplanEntity fundrecoveryplanEntity = fundrecoveryplanList.get(0);
            resVO5.setLinkBillId(fundrecoveryplanEntity.getId());
            resVO5.setLinkBillCode(fundrecoveryplanEntity.getBillCode());
        }
        resVO5.setLinkBillName("项目资金回收流程策划");
        resList.add(resVO5);

        //6.项目资金管理策划
        QueryWrapper<FundsplanningEntity> queryWrapperFundsplanning = new QueryWrapper<>();
        queryWrapperFundsplanning.eq("dr", 0);
        queryWrapperFundsplanning.eq("project_id", projectId);
        queryWrapperFundsplanning.in("bill_state", "1","3");
        List<FundsplanningEntity> fundsplanningList = fundsplanningService.list(queryWrapperFundsplanning);

        ChangecountersignaturedetailVO resVO6 = new ChangecountersignaturedetailVO();
        resVO6.setId(IdWorker.getId());
        if(fundsplanningList != null && fundsplanningList.size() > 0){
            FundsplanningEntity fundsplanningEntity = fundsplanningList.get(0);
            resVO6.setLinkBillId(fundsplanningEntity.getId());
            resVO6.setLinkBillCode(fundsplanningEntity.getBillCode());
        }
        resVO6.setLinkBillName("项目资金管理策划");
        resList.add(resVO6);

        //7.总包合同履约策划
        CommonResponse<JSONObject> jsonObj = honouragreementApi.queryLastDataByProjectId(projectId);
        JSONObject data = jsonObj.getData();

        ChangecountersignaturedetailVO resVO7 = new ChangecountersignaturedetailVO();

        JSONObject dataManage = null;
        JSONObject riskMonitor = null;
        if(data != null){
            dataManage = data.getJSONObject("dataManage");
            riskMonitor = data.getJSONObject("riskMonitor");
        }
        if(dataManage != null){
            String dataManageId = dataManage.get("id") == null ? "" : dataManage.get("id").toString();
            String dataManageBillCode = dataManage.get("billCode") == null ? "" : dataManage.get("billCode").toString();
            if(!dataManageId.isEmpty()){
                resVO7.setLinkBillId(Long.parseLong(dataManageId));
            }
            resVO7.setLinkBillCode(dataManageBillCode);
        }

        resVO7.setId(IdWorker.getId());
        resVO7.setLinkBillName("总包合同履约策划");
        resList.add(resVO7);

        //8.合同风险识别与策划
        ChangecountersignaturedetailVO resVO8 = new ChangecountersignaturedetailVO();

        if(riskMonitor != null){
            String riskMonitorId = riskMonitor.get("id") == null ? "" : riskMonitor.get("id").toString();
            String riskMonitorBillCode = riskMonitor.get("billCode") == null ? "" : riskMonitor.get("billCode").toString();
            if(!riskMonitorId.isEmpty()){
                resVO8.setLinkBillId(Long.parseLong(riskMonitorId));
            }
            resVO8.setLinkBillCode(riskMonitorBillCode);
        }

        resVO8.setId(IdWorker.getId());
        resVO8.setLinkBillName("合同风险识别与策划");
        resList.add(resVO8);

        //9.项目商务策划效果
        QueryWrapper<BusinessplanningeffectEntity> queryWrapperBusinessplanningeffect = new QueryWrapper<>();
        queryWrapperBusinessplanningeffect.eq("dr", 0);
        queryWrapperBusinessplanningeffect.eq("project_id", projectId);
        queryWrapperBusinessplanningeffect.in("bill_state", "1","3");
        List<BusinessplanningeffectEntity> businessplanningeffectList = businessplanningeffectService.list(queryWrapperBusinessplanningeffect);

        ChangecountersignaturedetailVO resVO9 = new ChangecountersignaturedetailVO();
        resVO9.setId(IdWorker.getId());
        if(businessplanningeffectList != null && businessplanningeffectList.size() > 0){
            BusinessplanningeffectEntity bsinessplanningeffectEntity = businessplanningeffectList.get(0);
            resVO9.setLinkBillId(bsinessplanningeffectEntity.getId());
            resVO9.setLinkBillCode(bsinessplanningeffectEntity.getBillCode());
        }
        resVO9.setLinkBillName("项目商务策划效果");
        resList.add(resVO9);

        //10.分包、分供管理策划
        QueryWrapper<SubpackageEntity> queryWrapperSubpackage = new QueryWrapper<>();
        queryWrapperSubpackage.eq("dr", 0);
        queryWrapperSubpackage.eq("project_id", projectId);
        queryWrapperSubpackage.in("bill_state", "1","3");
        List<SubpackageEntity> subpackageList = subpackageService.list(queryWrapperSubpackage);

        ChangecountersignaturedetailVO resVO10 = new ChangecountersignaturedetailVO();
        resVO10.setId(IdWorker.getId());
        if(subpackageList != null && subpackageList.size() > 0){
            SubpackageEntity subpackageEntity = subpackageList.get(0);
            resVO10.setLinkBillId(subpackageEntity.getId());
            resVO10.setLinkBillCode(subpackageEntity.getBillCode());
        }
        resVO10.setLinkBillName("分包、分供管理策划");
        resList.add(resVO10);
        changeVO.setCountersignaturedetailEntities(resList);
        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangecountersignatureVO> saveOrUpdate(@RequestBody ChangecountersignatureVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangecountersignatureVO> queryDetail(Long id) {
    	ChangecountersignatureEntity entity = service.selectById(id);
    	ChangecountersignatureVO vo = BeanMapper.map(entity, ChangecountersignatureVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CountersignatureVO> vos) {
        return service.deleteCounterSignature(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangecountersignatureVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangecountersignatureEntity> page = service.queryPage(param,false);
        IPage<ChangecountersignatureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangecountersignatureVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangecountersignatureEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changecountersignature-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangecountersignatureData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangecountersignatureVO>> refChangecountersignatureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangecountersignatureEntity> page = service.queryPage(param,false);
        IPage<ChangecountersignatureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangecountersignatureVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
