package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.change.bean.ChangeFundsplanningEntity;
import com.ejianc.business.change.bean.ChangeFundsplanningdetailEntity;
import com.ejianc.business.change.service.IChangeFundsplanningService;
import com.ejianc.business.change.service.IChangeFundsplanningdetailService;
import com.ejianc.business.change.vo.ChangeFundsplanningVO;
import com.ejianc.business.change.vo.ChangeFundsplanningdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 项目资金管理策划变更单导入导出
 */
@Controller
@RequestMapping("changeFundsplanningExport")
public class ExcelChangeFundsplanningController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeFundsplanningdetailService changeFundsplanningdetailService;
    @Autowired
    private IChangeFundsplanningService service;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadFundsplanning")
    @ResponseBody
    public void downloadFundsplanning(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "fundsplanning-import.xlsx", "商务策划书导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportFundsplanning", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportFundsplanning(HttpServletRequest request, HttpServletResponse response, String id, String projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangeFundsplanningdetailVO> successList = new ArrayList<>();
        List<ChangeFundsplanningdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result != null && result.size() > 0) {
                    Long billId = null;
                    Long billProjectId = null;
                    if (id != null && !"null".equals(id)) {
                        billId = Long.parseLong(id);
                    } else {
                        billId = null;
                    }
                    if (projectId != null) {
                        billProjectId = Long.parseLong(projectId);
                    }
                    //获取往期
                    //往期主表
                    ChangeFundsplanningEntity pastVO = pastData(billId, billProjectId);
                    //往期子表
                    HashMap<String, ChangeFundsplanningdetailEntity> pastDetailMap = new HashMap<>();
                    if(pastVO != null){
                        List<ChangeFundsplanningdetailEntity> pastDetailVOList = pastVO.getFundsplanningdetailEntities();
                        if (pastDetailVOList != null && pastDetailVOList.size() > 0) {
                            for (int i = 0; i < pastDetailVOList.size(); i++) {
                                ChangeFundsplanningdetailEntity pastDetailVO = pastDetailVOList.get(i);
                                pastDetailMap.put(pastDetailVO.getCollectbranchTime1(), pastDetailVO);
                            }
                        }
                    }

                    for (int i = 2; i < result.size(); i++) {
                        List<String> datas = result.get(i);
                        ChangeFundsplanningdetailVO fundsplanningdetailVO = new ChangeFundsplanningdetailVO();

                        fundsplanningdetailVO.setId(IdWorker.getId());//id
                        fundsplanningdetailVO.setSort(datas.get(0)); // 序号
//                    fundsplanningdetailVO.setCollectbranchTime(StringUtils.isNotBlank(datas.get(1))? DateUtils.Date((datas.get(1))):null); // 收支时间(日期)
                        fundsplanningdetailVO.setCollectbranchTime1(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 收支时间(日期)
                        fundsplanningdetailVO.setImagenode(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 形象进度节点情况
                        fundsplanningdetailVO.setPlancomplete(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : null); // 计划完成产值
                        fundsplanningdetailVO.setCivilengineering(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : new BigDecimal(0)); // 土建
                        fundsplanningdetailVO.setInstallation(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : new BigDecimal(0)); // 安装
                        fundsplanningdetailVO.setOther(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : new BigDecimal(0)); // 其它

                        //根据期号判断是否是往期数据（不校验，以系统带出数据为准）
                        if (pastDetailMap.get(fundsplanningdetailVO.getCollectbranchTime1()) != null) {
                            continue;
                        }

                        //总计
                        if (fundsplanningdetailVO.getCioAmount() == null || StringUtils.isBlank(datas.get(7))) {
                            BigDecimal cioAmountB = new BigDecimal(0);
                            if (fundsplanningdetailVO.getOther() != null) {
                                cioAmountB = cioAmountB.add(fundsplanningdetailVO.getOther());
                            }
                            if (fundsplanningdetailVO.getCivilengineering() != null) {
                                cioAmountB = cioAmountB.add(fundsplanningdetailVO.getCivilengineering());
                            }
                            if (fundsplanningdetailVO.getInstallation() != null) {
                                cioAmountB = cioAmountB.add(fundsplanningdetailVO.getInstallation());
                            }
                            fundsplanningdetailVO.setCioAmount(cioAmountB);
                        } else {
                            fundsplanningdetailVO.setCioAmount(new BigDecimal(datas.get(7)));
                        }

                        fundsplanningdetailVO.setLabourservices(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : new BigDecimal(0)); // 劳务
                        fundsplanningdetailVO.setMaterial(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : new BigDecimal(0)); // 材料
                        fundsplanningdetailVO.setProfessional(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : new BigDecimal(0)); // 专业分包
                        fundsplanningdetailVO.setOthercost(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : new BigDecimal(0)); // 其它费用
                        fundsplanningdetailVO.setAnswer(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 应对措施
                        fundsplanningdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(16)) ? datas.get(16) : null); // 备注
                        fundsplanningdetailVO.setSalary(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : new BigDecimal(0));

                        //当期
                        if (fundsplanningdetailVO.getCurrent() == null || StringUtils.isBlank(datas.get(13))) {
                            BigDecimal currentDec = fundsplanningdetailVO.getLabourservices().add(fundsplanningdetailVO.getMaterial())
                                    .add(fundsplanningdetailVO.getProfessional()).add(fundsplanningdetailVO.getOthercost())
                                    .add(fundsplanningdetailVO.getSalary());
                            fundsplanningdetailVO.setCurrent(fundsplanningdetailVO.getCioAmount().subtract(currentDec));
                        } else {
                            fundsplanningdetailVO.setCurrent(new BigDecimal(datas.get(13)));
                        }

                        if (StringUtils.isEmpty(datas.get(0))) {
                            fundsplanningdetailVO.setErrorMsg("序号不能为空！");
                            errorList.add(fundsplanningdetailVO);
                            continue;
                        }
                        successList.add(fundsplanningdetailVO);
                    }
                }
            }

            //重新计算累计值
            if (successList.size() > 0) {
                ChangeFundsplanningdetailVO lastVO = null;
                for (int i = 0; i < successList.size(); i++) {
                    ChangeFundsplanningdetailVO detailVO = successList.get(i);
                    if (lastVO == null) {//累计 = 本期
                        //累计
                        detailVO.setCumulative(detailVO.getCurrent());
                    } else {//累计 = 往期 + 本期
                        //累计
                        BigDecimal lastCumulative = lastVO.getCumulative();
                        detailVO.setCumulative(lastCumulative.add(detailVO.getCurrent()));
                    }

                    lastVO = detailVO;
                }
            }

            JSONObject json = new JSONObject();
            json.put("successNum", successList.size());
            json.put("successList", successList);
            json.put("errorList", errorList);
            json.put("errorNum", errorList.size());
            return CommonResponse.success(json);
        }
    }

    /**
     * @param projectId
     * @Description
     */
    public ChangeFundsplanningEntity pastData(Long id, Long projectId) {
        //本期日期
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            ChangeFundsplanningEntity currentEntity = service.selectById(id);
            currentDate = currentEntity.getCreateTime();
        }
        return getPastData(projectId, currentDate);
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param projectId  项目id
     * @param currentDate 本期日期
     */
    private ChangeFundsplanningEntity getPastData(Long projectId, Date currentDate) {
        QueryWrapper<ChangeFundsplanningEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("bill_state", 1, 3);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.lt("create_time", currentDate);
        queryWrapper.orderByDesc("create_time");//
        queryWrapper.last("limit 1");//最新生效的一期
        List<ChangeFundsplanningEntity> fundsplanningEntityList = service.list(queryWrapper);

        ChangeFundsplanningEntity resEntity = null;

        if(fundsplanningEntityList == null || fundsplanningEntityList.size() == 0){
            return null;
        }
        //往期子表
        resEntity = fundsplanningEntityList.get(0);
        QueryWrapper<ChangeFundsplanningdetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("mid", resEntity.getId());
        queryWrapper.eq("dr", 0);
        List<ChangeFundsplanningdetailEntity> fundsplanningdetailEntityList = changeFundsplanningdetailService.list(wrapper);
        if(fundsplanningdetailEntityList != null && fundsplanningdetailEntityList.size() > 0){
            for (ChangeFundsplanningdetailEntity detail:
                    fundsplanningdetailEntityList) {
                detail.setPastFlag(1);
            }

            resEntity.setFundsplanningdetailEntities(fundsplanningdetailEntityList);
        }
        return resEntity;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportFundsplanningFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportFundsplanningFromDatabase(@RequestBody ChangeFundsplanningVO fundsVo, HttpServletResponse response) {
        QueryWrapper<ChangeFundsplanningdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", fundsVo.getId());
        queryWrapper.eq("dr", 0);
        List<ChangeFundsplanningdetailEntity> list = changeFundsplanningdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportFundsplanningFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportFundsplanningFromPage(@RequestBody List<ChangeFundsplanningdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangeFundsplanningdetailVO maintargetdetailVO = list.get(i);
                maintargetdetailVO.setSort(String.valueOf(i + 1));
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }
}
