package com.ejianc.business.busniessplan.service.impl;

import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.bean.CountersignaturedetailEntity;
import com.ejianc.business.busniessplan.service.ICountersignatureService;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("countersignature") 
public class CountersignatureBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ICountersignatureService countersignatureService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("提交前回调");
		//TODO
		//校验单据的数据
		CountersignatureEntity countersignatureEntity = countersignatureService.selectById(billId);
		List<CountersignaturedetailEntity> countersignaturedetailEntities = countersignatureEntity.getCountersignaturedetailEntities();
		if (CollectionUtils.isEmpty(countersignaturedetailEntities)){
			throw new BusinessException("所有清单有数据才能提交!");
		}
		boolean b = countersignaturedetailEntities.stream().anyMatch(s -> s.getLinkBillId() == null);
		logger.info("测试状态"+b);

		if (b){
			throw new BusinessException("所有清单有数据才能提交!");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		logger.info("提交完回调");
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("有审批流的撤回前回调");

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("有审批流的撤回后回调");
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("审批节点审批中时节点审批前回调");
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审审核前回调");
		logger.info("state"+state);
		logger.info("提交前回调");
		//TODO
		//校验单据的数据
		CountersignatureEntity countersignatureEntity = countersignatureService.selectById(billId);
		List<CountersignaturedetailEntity> countersignaturedetailEntities = countersignatureEntity.getCountersignaturedetailEntities();
		if (CollectionUtils.isEmpty(countersignaturedetailEntities)){
			throw new BusinessException("所有清单有数据才能提交!");
		}
		boolean b = countersignaturedetailEntities.stream().anyMatch(s -> s.getLinkBillId() == null);
		logger.info("测试状态"+b);

		if (b){
			throw new BusinessException("所有清单有数据才能提交!");
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审审核完回调");
		logger.info("state"+state);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("弃审前事件回调");

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("弃审后事件回调");
		return CommonResponse.success();
	}

}
