package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectService;
import com.ejianc.business.change.bean.ChangePlanprojectEntity;
import com.ejianc.business.change.service.IChangePlanprojectService;
import com.ejianc.business.change.vo.ChangePlanprojectVO;
import com.ejianc.business.change.vo.ChangePlanprojectdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 项目商务策划立项变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changePlanproject")
public class ChangePlanprojectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangePlanprojectService service;
    @Autowired
    private IPlanprojectService planprojectService;

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailByPlanprojectId")
    @ResponseBody
    public CommonResponse<ChangePlanprojectVO> queryDetailByPlanprojectId(@RequestParam(value = "planprojectId") Long planprojectId) {
        PlanprojectEntity quotaanalysisVO = planprojectService.selectById(planprojectId);
        ChangePlanprojectVO changeVO = BeanMapper.map(quotaanalysisVO, ChangePlanprojectVO.class);
        Long id = IdWorker.getId();
        changeVO.setPlanprojectId(planprojectId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //子表
        List<PlanprojectdetailEntity> planprojectdetailList = quotaanalysisVO.getPlanprojectdetailEntities();
        if(planprojectdetailList!=null&&planprojectdetailList.size()>0){
            List<ChangePlanprojectdetailVO> changePlanprojectdetailVO = new ArrayList<>();
            for(PlanprojectdetailEntity entity : planprojectdetailList){
                ChangePlanprojectdetailVO vo = BeanMapper.map(entity, ChangePlanprojectdetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changePlanprojectdetailVO.add(vo);
            }
            List<ChangePlanprojectdetailVO> resPlanprojectdetailVO = createTreeData(changePlanprojectdetailVO);
            changeVO.setPlanprojectdetailEntities(resPlanprojectdetailVO);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangePlanprojectVO> saveOrUpdate(@RequestBody ChangePlanprojectVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangePlanprojectVO> queryDetail(Long id) {
    	ChangePlanprojectEntity entity = service.selectById(id);
    	ChangePlanprojectVO vo = BeanMapper.map(entity, ChangePlanprojectVO.class);

        //构建树形结构
        List<ChangePlanprojectdetailVO> planprojectdetailVO = vo.getPlanprojectdetailEntities();
        List<ChangePlanprojectdetailVO> resPlanprojectdetailVO = createTreeData(planprojectdetailVO);
        vo.setPlanprojectdetailEntities(resPlanprojectdetailVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangePlanprojectVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangePlanprojectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangePlanprojectEntity> page = service.queryPage(param,false);
        IPage<ChangePlanprojectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangePlanprojectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangePlanprojectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangePlanproject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangePlanprojectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangePlanprojectVO>> refChangePlanprojectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangePlanprojectEntity> page = service.queryPage(param,false);
        IPage<ChangePlanprojectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangePlanprojectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<ChangePlanprojectdetailVO> createTreeData(List<ChangePlanprojectdetailVO> list) {
        List<ChangePlanprojectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangePlanprojectdetailVO> listMap = new HashMap<>();
        for(ChangePlanprojectdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangePlanprojectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangePlanprojectdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangePlanprojectdetailVO> child = (List<ChangePlanprojectdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangePlanprojectdetailVO> children = new ArrayList<ChangePlanprojectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
