package com.ejianc.business.record.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目资金管理策划变更记录表
 * 
 * @author generator
 * 
 */
public class RecordFundsplanningVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long agentId; // 经办人id
    private String agentName; // 经办人名称
    private String remarks; // 备注
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    
    private List<RecordFundsplanningdetailVO> recordFundsplanningdetailVos = new ArrayList<>(); // 项目资金管理策划变更记录子表
    private String changeReason;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectTime;

    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人名称
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人名称
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     /**
      * 项目资金管理策划变更记录子表
      */
     public List<RecordFundsplanningdetailVO> getRecordFundsplanningdetailVos() {
        return recordFundsplanningdetailVos;
     }

     /**
      * 项目资金管理策划变更记录子表
      */
     public void setRecordFundsplanningdetailVos(List<RecordFundsplanningdetailVO> recordFundsplanningdetailVos) {
        this.recordFundsplanningdetailVos = recordFundsplanningdetailVos;
     }
}
