package com.ejianc.business.busniessplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectEntity;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectService;
import com.ejianc.business.busniessplan.service.IPlanprojectService;
import com.ejianc.business.busniessplan.service.IPlanprojectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.record.bean.RecordbusinessplanningeffectEntity;
import com.ejianc.business.record.service.IRecordbusinessplanningeffectService;
import com.ejianc.business.record.vo.RecordbusinessplanningeffectVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目商务策划效果
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("businessplanningeffect")
public class BusinessplanningeffectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;


    private static final String BILL_CODE = "businessplan-businessplanningeffect";//此处需要根据实际修改

    @Autowired
    private IBusinessplanningeffectService service;
    @Autowired
    private IRecordbusinessplanningeffectService recordbusinessplanningeffectService;
    @Autowired
    private IPlanprojectService planprojectService;
    @Autowired
    private IPlanprojectdetailService planprojectdetailService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusinessplanningeffectVO> saveOrUpdate(@RequestBody BusinessplanningeffectVO saveorUpdateVO) {
    	BusinessplanningeffectEntity entity = BeanMapper.map(saveorUpdateVO, BusinessplanningeffectEntity.class);

        QueryWrapper<BusinessplanningeffectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        List<BusinessplanningeffectEntity> pro = service.list(queryWrapper);
        queryWrapper.eq("dr", "0");
    	if(entity.getId() == null || entity.getId() == 0){
            if( pro.size() > 0){
                throw new BusinessException("该项目已经创建一个项目策划效果，不允许重复创建!");
            }
        }else {
            if(pro.size() > 0){
                for (int i = 0; i < pro.size(); i++) {
                    if(!entity.getId().equals(pro.get(i).getId())){
                        throw new BusinessException("该项目已经创建一个项目策划效果，不允许重复创建!");
                    }
                }
            }
        }
        BusinessplanningeffectEntity businessplanningeffectEntity = checkBillCodeUniq(entity);
        entity.setChangeState("1");
        businessplanningeffectEntity.setCostEstimateTotal(saveorUpdateVO.getCostEstimateTotal()==null? null : saveorUpdateVO.getCostEstimateTotal());
        businessplanningeffectEntity.setReportAmountTotal(saveorUpdateVO.getReportAmountTotal()==null? null : saveorUpdateVO.getReportAmountTotal());
        businessplanningeffectEntity.setTargetAmountTotal(saveorUpdateVO.getTargetAmountTotal()==null? null : saveorUpdateVO.getTargetAmountTotal());
        businessplanningeffectEntity.setCompleteAmountTotal(saveorUpdateVO.getCompleteAmountTotal()==null? null : saveorUpdateVO.getCompleteAmountTotal());
        businessplanningeffectEntity.setEstimateProfitsTotal(saveorUpdateVO.getEstimateProfitsTotal()==null? null : saveorUpdateVO.getEstimateProfitsTotal());
        List<BusinessplanningeffectdetailEntity> list = new ArrayList<>();
//        for(BusinessplanningeffectdetailEntity businessplanningeffectdetailEntity : businessplanningeffectEntity.getBusinessplanningeffectdetailEntities()){
//            if (!"del".equals(businessplanningeffectdetailEntity.getRowState())) {
//                businessplanningeffectdetailEntity.setId(null);
//                list.add(businessplanningeffectdetailEntity);
//            }
//        }
//        businessplanningeffectEntity.setBusinessplanningeffectdetailEntities(list);
        service.saveOrUpdate(businessplanningeffectEntity, false);
    	BusinessplanningeffectVO vo = BeanMapper.map(entity, BusinessplanningeffectVO.class);

        //构建树形结构
//        List<BusinessplanningeffectdetailVO> businessplanningeffectVO = vo.getBusinessplanningeffectdetailEntities();
//        List<BusinessplanningeffectdetailVO> resBusinessplanningeffectVO = createTreeData(businessplanningeffectVO);
//        vo.setBusinessplanningeffectdetailEntities(resBusinessplanningeffectVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private BusinessplanningeffectEntity checkBillCodeUniq(BusinessplanningeffectEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<BusinessplanningeffectEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<BusinessplanningeffectEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    BusinessplanningeffectEntity businessplanningeffectCode = proBillCode.get(i);
                    if(!businessplanningeffectCode.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }

        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BusinessplanningeffectVO> queryDetail(Long id) {
    	BusinessplanningeffectEntity entity = service.selectById(id);
    	BusinessplanningeffectVO vo = BeanMapper.map(entity, BusinessplanningeffectVO.class);

        //构建树形结构
        List<BusinessplanningeffectdetailVO> businessplanningeffectVO = vo.getBusinessplanningeffectdetailEntities();
//        businessplanningeffectVO.forEach(p -> p.setSortNum(Integer.parseInt(p.getSort())));
//        for (BusinessplanningeffectdetailVO businessplanningeffectdetailVO : businessplanningeffectVO){
//            if (NumberUtils.isCreatable(businessplanningeffectdetailVO.getSort())){
//                businessplanningeffectdetailVO.setSortNum(Integer.parseInt(businessplanningeffectdetailVO.getSort()));
//            }else {
//
//            }
//        }
        List<BusinessplanningeffectdetailVO> collect = businessplanningeffectVO.stream().sorted(Comparator.comparing(BusinessplanningeffectdetailVO::getSort)).collect(Collectors.toList());
//        List<BusinessplanningeffectdetailVO> resBusinessplanningeffectVO = createTreeData(businessplanningeffectVO);
        vo.setBusinessplanningeffectdetailEntities(collect);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordbusinessplanningeffectEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("businessplanningeffect_id", vo.getId());
            List<RecordbusinessplanningeffectEntity> records = recordbusinessplanningeffectService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordbusinessplanningeffectList(BeanMapper.mapList(records, RecordbusinessplanningeffectVO.class));
            }
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessplanningeffectVO> vos) {
        service.removeByIds(vos.stream().map(BusinessplanningeffectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BusinessplanningeffectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        IPage<BusinessplanningeffectEntity> page = service.queryPage(param,false);
        IPage<BusinessplanningeffectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusinessplanningeffectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<BusinessplanningeffectEntity> list = service.queryList(param);
        //时间转换
        List<BusinessplanningeffectVO> businessplanningeffectList = BeanMapper.mapList(list, BusinessplanningeffectVO.class);
        for (int i = 0; i < businessplanningeffectList.size(); i++) {
            BusinessplanningeffectVO businessplanningeffectVO = businessplanningeffectList.get(i);
            businessplanningeffectVO.setSort(String.valueOf(i+1));
            if (businessplanningeffectVO.getCreateTime()!=null){
                businessplanningeffectVO.setCreateTimeShow(DateUtils.dateSimple2(businessplanningeffectVO.getCreateTime()));
            }

            String billStateStr = businessplanningeffectVO.getBillState().toString();
            String changeState = businessplanningeffectVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                businessplanningeffectVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                businessplanningeffectVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", businessplanningeffectList);
        ExcelExport.getInstance().export("BusinessplanningeffectMain-export.xlsx", beans, response);
    }

    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBusinessplanningeffectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BusinessplanningeffectVO>> refBusinessplanningeffectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BusinessplanningeffectEntity> page = service.queryPage(param,false);
        IPage<BusinessplanningeffectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusinessplanningeffectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<BusinessplanningeffectdetailVO> createTreeData(List<BusinessplanningeffectdetailVO> list) {
        List<BusinessplanningeffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, BusinessplanningeffectdetailVO> listMap = new HashMap<>();
        for(BusinessplanningeffectdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            BusinessplanningeffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            BusinessplanningeffectdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<BusinessplanningeffectdetailVO> child = (List<BusinessplanningeffectdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<BusinessplanningeffectdetailVO> children = new ArrayList<BusinessplanningeffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long projectId) {
        QueryWrapper<PlanprojectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", "1","3");

        List<PlanprojectEntity> entityList = planprojectService.list(queryWrapper);

        if (entityList == null || entityList.size() == 0) {
            return CommonResponse.success("该项目暂无已审批通过的项目商务策划立项，请选择其他项目!", "0");
        }

        return CommonResponse.success("查询成功！", "1");
    }
    @RequestMapping(value = "/queryPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanprojectVO> queryPlan(Long projectId) {
        QueryWrapper<PlanprojectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", 1,3);
        List<PlanprojectEntity> entityList = planprojectService.list(queryWrapper);

        QueryWrapper<PlanprojectdetailEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("mid", entityList.get(0).getId());
        List<PlanprojectdetailEntity> list = planprojectdetailService.list(queryWrapper1);
        entityList.get(0).setPlanprojectdetailEntities(list);
        PlanprojectVO entity = BeanMapper.map(entityList.get(0), PlanprojectVO.class);
        List<PlanprojectdetailVO> businessplanningeffectdetailEntities = entity.getPlanprojectdetailEntities();
        for(PlanprojectdetailVO planprojectdetailVO : businessplanningeffectdetailEntities){
            planprojectdetailVO.setId(IdWorker.getId());
        }

        List<PlanprojectdetailVO> treeData = createTreeData1(businessplanningeffectdetailEntities);
        entity.setPlanprojectdetailEntities(treeData);
        return CommonResponse.success("查询成功！", entity);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<PlanprojectdetailVO> createTreeData1(List<PlanprojectdetailVO> list) {
        List<PlanprojectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, PlanprojectdetailVO> listMap = new HashMap<>();
        for (PlanprojectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            PlanprojectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            PlanprojectdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<PlanprojectdetailVO> child = (List<PlanprojectdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<PlanprojectdetailVO> children = new ArrayList<PlanprojectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    }
