package com.ejianc.business.car.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 人员工资
 * 
 * @author generator
 * 
 */
public class WageEnterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private String wageOrgName; // 组织名称
    private Long wageOrgId; //组织
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private String departmentName; // 经办部门
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date salaryMoth; // 月份
    private BigDecimal totalSalaryMny; // 实发工资合计
    private String memo; // 备注
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private List<WageEnterDetailVO> detailList = new ArrayList<>();

    public List<WageEnterDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<WageEnterDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getWageOrgName() {
        return wageOrgName;
    }

    public void setWageOrgName(String wageOrgName) {
        this.wageOrgName = wageOrgName;
    }
    @ReferSerialTransfer(referCode = "wage-user")
    public Long getWageOrgId() {
        return wageOrgId;
    }
    @ReferDeserialTransfer
    public void setWageOrgId(Long wageOrgId) {
        this.wageOrgId = wageOrgId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getSalaryMoth() {
        return salaryMoth;
    }

    public void setSalaryMoth(Date salaryMoth) {
        this.salaryMoth = salaryMoth;
    }
    public BigDecimal getTotalSalaryMny() {
        return totalSalaryMny;
    }

    public void setTotalSalaryMny(BigDecimal totalSalaryMny) {
        this.totalSalaryMny = totalSalaryMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
