package com.ejianc.business.car.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;


/**
 * 车辆信息
 *
 * @author generator
 *
 */
public class CarVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long carTypeId; // 车辆类型
    private String carTypeName; // 车辆类型
    private Long carModelId; // 型号
    private String carModelName; // 型号
    private String carName; // 设备名称
    private String code; // 车牌号
    private Long orgId; // 所属公司
    private String orgName; // 所属公司
    private String brand; // 品牌
    private String vinNo; // 车架号
    private String engineNo; // 发动机号

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date registDate; // 注册日期

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date certDate; // 发证日期
    private BigDecimal totalWeight; // 总质量
    private BigDecimal allWeight; // 整备质量
    private BigDecimal checkWeight; // 核定载质量
    private BigDecimal buyPrice; // 购车价

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date yearCheckDate; // 年检时间

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date insureForceDate; // 保险时间(强制险)

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date insureBusinessDate; // 保险时间(商业险)
    private String oilCard; // 油卡号
    private Long carAreaId; // 车辆所在区域
    private String carAreaName; // 车辆所在区域
    private Long carProjectId; // 所属项目
    private String carProjectName; // 所属项目
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private String departmentName; // 经办部门
    private String memo; // 备注
    private Integer billState; // 单据状态

    private String yearCheckDesc; // 年检状态描述

    private Long yearCheckSurplusDays; // 年检剩余天数

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date scrapDate; // 报废时间
    private String carSize; // 外廓尺寸
    private String insureCompany; // 保险公司

    public Date getScrapDate() {
        return scrapDate;
    }

    public void setScrapDate(Date scrapDate) {
        this.scrapDate = scrapDate;
    }

    public String getCarSize() {
        return carSize;
    }

    public void setCarSize(String carSize) {
        this.carSize = carSize;
    }

    public String getInsureCompany() {
        return insureCompany;
    }

    public void setInsureCompany(String insureCompany) {
        this.insureCompany = insureCompany;
    }

    public String getYearCheckDesc() {
        return yearCheckDesc;
    }

    public Long getYearCheckSurplusDays() {
        return yearCheckSurplusDays;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarTypeId() {
        return carTypeId;
    }

    @ReferDeserialTransfer
    public void setCarTypeId(Long carTypeId) {
        this.carTypeId = carTypeId;
    }

    public String getCarTypeName() {
        return carTypeName;
    }

    public void setCarTypeName(String carTypeName) {
        this.carTypeName = carTypeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarModelId() {
        return carModelId;
    }

    @ReferDeserialTransfer
    public void setCarModelId(Long carModelId) {
        this.carModelId = carModelId;
    }

    public String getCarModelName() {
        return carModelName;
    }

    public void setCarModelName(String carModelName) {
        this.carModelName = carModelName;
    }

    public String getCarName() {
        return carName;
    }

    public void setCarName(String carName) {
        this.carName = carName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }


    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getVinNo() {
        return vinNo;
    }

    public void setVinNo(String vinNo) {
        this.vinNo = vinNo;
    }

    public String getEngineNo() {
        return engineNo;
    }

    public void setEngineNo(String engineNo) {
        this.engineNo = engineNo;
    }

    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public Date getCertDate() {
        return certDate;
    }

    public void setCertDate(Date certDate) {
        this.certDate = certDate;
    }

    public BigDecimal getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    public BigDecimal getAllWeight() {
        return allWeight;
    }

    public void setAllWeight(BigDecimal allWeight) {
        this.allWeight = allWeight;
    }

    public BigDecimal getCheckWeight() {
        return checkWeight;
    }

    public void setCheckWeight(BigDecimal checkWeight) {
        this.checkWeight = checkWeight;
    }

    public BigDecimal getBuyPrice() {
        return buyPrice;
    }

    public void setBuyPrice(BigDecimal buyPrice) {
        this.buyPrice = buyPrice;
    }

    public Date getYearCheckDate() {
        return yearCheckDate;
    }

    public void setYearCheckDate(Date yearCheckDate) {
        this.yearCheckDate = yearCheckDate;
        LocalDate localYearCheckDate =
                yearCheckDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        this.yearCheckSurplusDays = ChronoUnit.DAYS.between(LocalDate.now(), localYearCheckDate);
        if (this.yearCheckSurplusDays <= 0) {
            this.yearCheckDesc = "已过期";
        } else if (this.yearCheckSurplusDays > 60) {
            this.yearCheckDesc = "正常";
        } else {
            this.yearCheckDesc = "还有" + this.yearCheckSurplusDays + "天到期";
        }
    }

    public Date getInsureForceDate() {
        return insureForceDate;
    }

    public void setInsureForceDate(Date insureForceDate) {
        this.insureForceDate = insureForceDate;
    }

    public Date getInsureBusinessDate() {
        return insureBusinessDate;
    }

    public void setInsureBusinessDate(Date insureBusinessDate) {
        this.insureBusinessDate = insureBusinessDate;
    }

    public String getOilCard() {
        return oilCard;
    }

    public void setOilCard(String oilCard) {
        this.oilCard = oilCard;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarAreaId() {
        return carAreaId;
    }

    @ReferDeserialTransfer
    public void setCarAreaId(Long carAreaId) {
        this.carAreaId = carAreaId;
    }

    public String getCarAreaName() {
        return carAreaName;
    }

    public void setCarAreaName(String carAreaName) {
        this.carAreaName = carAreaName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getCarProjectId() {
        return carProjectId;
    }

    @ReferDeserialTransfer
    public void setCarProjectId(Long carProjectId) {
        this.carProjectId = carProjectId;
    }


    public String getCarProjectName() {
        return carProjectName;
    }

    public void setCarProjectName(String carProjectName) {
        this.carProjectName = carProjectName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

}
