package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.utils.DetailIndexExcelReader2;
import com.ejianc.business.car.vo.ImportErrorVo;
import com.ejianc.business.car.vo.OilFeeReportVo;
import com.ejianc.business.car.vo.SalaryReportVo;
import com.ejianc.business.car.vo.WageEnterDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.car.mapper.WageEnterMapper;
import com.ejianc.business.car.bean.WageEnterEntity;
import com.ejianc.business.car.service.IWageEnterService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人员工资
 * 
 * @author generator
 * 
 */
@Service("wageEnterService")
public class WageEnterServiceImpl extends BaseServiceImpl<WageEnterMapper, WageEnterEntity> implements IWageEnterService{

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        }else {
            List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
            List<List<String>> result = resList.get(0);
            List<ImportErrorVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<WageEnterDetailVO> detailVoList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    WageEnterDetailVO vo = new WageEnterDetailVO();
                    boolean flag = false;
                    String warnType = "";
                    if (StringUtils.isEmpty(datas.get(0))){
                        vo.setDetailIndex(null);
                    }else {
                        vo.setDetailIndex(datas.get(0));
                    }
                    if(StringUtils.isEmpty(datas.get(1))){// 姓名
                        vo.setName(null);
//                        warnType = warnType+"姓名为空,";
//                        flag = true;
                    }else{
                        vo.setName(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {
                        vo.setShouldDay(null);
                    } else {
                        try {
                            vo.setShouldDay(new BigDecimal(datas.get(2)));
                        } catch (Exception e) {
                            vo.setShouldDay(null);
                            warnType = warnType+"应出勤天数只能为数字或小数,";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(3))) {
                        vo.setActualDay(null);
                    } else {
                        try {
                            vo.setActualDay(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            vo.setActualDay(null);
                            warnType = warnType + "实际出勤天数只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setBaseBay(null);
                    } else {
                        try {
                            vo.setBaseBay(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setBaseBay(null);
                            warnType = warnType+"基本工资只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setJobSubsidy(null);
                    } else {
                        try {
                            vo.setJobSubsidy(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setJobSubsidy(null);
                            warnType = warnType+"岗位补贴只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setPerformance(null);
                    } else {
                        try {
                            vo.setPerformance(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setPerformance(null);
                            warnType = warnType+"绩效只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setPhoneSubsidy(null);
                    } else {
                        try {
                            vo.setPhoneSubsidy(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setPhoneSubsidy(null);
                            warnType = warnType+"话补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setRoomSubsidy(null);
                    } else {
                        try {
                            vo.setRoomSubsidy(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setRoomSubsidy(null);
                            warnType = warnType+"房补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setCarSubsidy(null);
                    } else {
                        try {
                            vo.setCarSubsidy(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setCarSubsidy(null);
                            warnType = warnType+"车补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        vo.setElectricitySubsidy(null);
                    } else {
                        try {
                            vo.setElectricitySubsidy(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setElectricitySubsidy(null);
                            warnType = warnType+"电补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(11))) {
                        vo.setOilSubsidy(null);
                    } else {
                        try {
                            vo.setOilSubsidy(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            vo.setOilSubsidy(null);
                            warnType = warnType+"油补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(12))) {
                        vo.setMealSubsidy(null);
                    } else {
                        try {
                            vo.setMealSubsidy(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            vo.setMealSubsidy(null);
                            warnType = warnType+"餐补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(13))) {
                        vo.setHyperthermiaSubsidy(null);
                    } else {
                        try {
                            vo.setHyperthermiaSubsidy(new BigDecimal(datas.get(13)));
                        } catch (Exception e) {
                            vo.setHyperthermiaSubsidy(null);
                            warnType = warnType+"高温补只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(14))) {
                        vo.setOtherSubsidy(null);
                    } else {
                        try {
                            vo.setOtherSubsidy(new BigDecimal(datas.get(14)));
                        } catch (Exception e) {
                            vo.setOtherSubsidy(null);
                            warnType = warnType+"其他补贴只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(15))) {
                        vo.setCoverShiftToilet(null);
                    } else {
                        try {
                            vo.setCoverShiftToilet(new BigDecimal(datas.get(15)));
                        } catch (Exception e) {
                            vo.setCoverShiftToilet(null);
                            warnType = warnType+"公厕只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(16))) {
                        vo.setCoverShiftGps(null);
                    } else {
                        try {
                            vo.setCoverShiftGps(new BigDecimal(datas.get(16)));
                        } catch (Exception e) {
                            vo.setCoverShiftGps(null);
                            warnType = warnType+"GPS只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(17))) {
                        vo.setCoverShiftSegment(null);
                    } else {
                        try {
                            vo.setCoverShiftSegment(new BigDecimal(datas.get(17)));
                        } catch (Exception e) {
                            vo.setCoverShiftSegment(null);
                            warnType = warnType+"路段只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(18))) {
                        vo.setOvertimeDay(null);
                    } else {
                        try {
                            vo.setOvertimeDay(new BigDecimal(datas.get(18)));
                        } catch (Exception e) {
                            vo.setOvertimeDay(null);
                            warnType = warnType+"加班 天/时只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(19))) {
                        vo.setOvertimeMny(null);
                    } else {
                        try {
                            vo.setOvertimeMny(new BigDecimal(datas.get(19)));
                        } catch (Exception e) {
                            vo.setOvertimeMny(null);
                            warnType = warnType+"加班 金额只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(20))) {
                        vo.setVacationDay(null);
                    } else {
                        try {
                            vo.setVacationDay(new BigDecimal(datas.get(20)));
                        } catch (Exception e) {
                            vo.setVacationDay(null);
                            warnType = warnType+"事假 天/时只能为数字或小数,";
                            flag = true;
                        }
                    }



                    if (StringUtils.isEmpty(datas.get(21))) {
                        vo.setVacationMny(null);
                    } else {
                        try {
                            vo.setVacationMny(new BigDecimal(datas.get(21)));
                        } catch (Exception e) {
                            vo.setVacationMny(null);
                            warnType = warnType+"事假金额只能为数字或小数,";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(22))) {
                        vo.setFestivalMny(null);
                    } else {
                        try {
                            vo.setFestivalMny(new BigDecimal(datas.get(22)));
                        } catch (Exception e) {
                            vo.setFestivalMny(null);
                            warnType = warnType+"节日费只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(23))) {
                        vo.setOtherDeductMny(null);
                    } else {
                        try {
                            vo.setOtherDeductMny(new BigDecimal(datas.get(23)));
                        } catch (Exception e) {
                            vo.setOtherDeductMny(null);
                            warnType = warnType+"其他扣款只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(24))) {
                        vo.setShouldPayMny(null);
                    } else {
                        try {
                            vo.setShouldPayMny(new BigDecimal(datas.get(24)));
                        } catch (Exception e) {
                            vo.setShouldPayMny(null);
                            warnType = warnType+"应发工资只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(25))) {
                        vo.setSocialSecurity(null);
                    } else {
                        try {
                            vo.setSocialSecurity(new BigDecimal(datas.get(25)));
                        } catch (Exception e) {
                            vo.setSocialSecurity(null);
                            warnType = warnType+"社保(代扣代缴)只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(26))) {
                        vo.setIndividualIncomeTax(null);
                    } else {
                        try {
                            vo.setIndividualIncomeTax(new BigDecimal(datas.get(26)));
                        } catch (Exception e) {
                            vo.setIndividualIncomeTax(null);
                            warnType = warnType+"个税只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(27))) {
                        vo.setActualPayMny(null);
                    } else {
                        try {
                            vo.setActualPayMny(new BigDecimal(datas.get(27)));
                        } catch (Exception e) {
                            vo.setActualPayMny(null);
                            warnType = warnType+"实发工资只能为数字或小数,";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(28))) {//
                        vo.setBankCode(null);
                    } else {
                        vo.setBankCode(datas.get(28));
                    }
                    if (StringUtils.isEmpty(datas.get(29))) {//
                        vo.setMemo(null);
                    } else {
                        vo.setMemo(datas.get(29));
                    }
                    vo.setSourceType(3);

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    detailVoList.add(vo);
                }
                List<WageEnterDetailVO> successList = new ArrayList<>();
                for (WageEnterDetailVO vo:detailVoList){
                    if (vo.getImportFlag()) {
                        successList.add(vo);
                    }else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getDetailIndex());
                        errorVo.setCode(null);
                        errorVo.setName(vo.getName());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
                resp.put("successList",detailVoList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public CommonResponse<String> queryUnEnter(Long wageOrgId, Date salaryMoth,Long id) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM");
        QueryWrapper<WageEnterEntity> queryWrapper = new QueryWrapper<>();
        if (null!=id){
            queryWrapper.ne("id",id);
        }
        queryWrapper.eq("wage_org_id",wageOrgId);
        queryWrapper.like("salary_moth",ft.format(salaryMoth));
        List<WageEnterEntity> list = super.list(queryWrapper);
        if (list.size()>0){
            return CommonResponse.error("该月份该组织已制单，不能重复新增！");
        }
        return CommonResponse.success("可以新增制单");
    }
    @Override
    public int queryByWageOrgId(Long wageOrgId,Long id) {
        QueryWrapper<WageEnterEntity> queryWrapper = new QueryWrapper<>();
        if (null!=id){
            queryWrapper.ne("id",id);
        }
        queryWrapper.eq("wage_org_id",wageOrgId);
        queryWrapper.notIn("bill_state",Arrays.asList(1,3));
        List<WageEnterEntity> list = super.list(queryWrapper);
        return list.size();
    }
    @Autowired
    private IOrgApi iOrgApi;
    @Override
    public JSONObject queryReport(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("oilCard");
        fuzzyFields.add("carName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("carAreaName");
        fuzzyFields.add("carCode");
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,billstate));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        Parameter yyear = param.getParams().get("yyear");
        Object value = null != yyear ? yyear.getValue():null;
        param.getParams().remove("yyear");
        Page<OilFeeReportVo> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper<OilFeeReportVo> wrapper = changeToQueryWrapper(param);
        wrapper.isNotNull("oil_card");
        wrapper.groupBy("car_id");
        wrapper.apply("YEAR(month_date) = "+value);
        List<SalaryReportVo> oilRecordReportVos = baseMapper.queryReport(pages, wrapper);
        jsonObject.put("records", oilRecordReportVos);
        jsonObject.put("total", pages.getTotal());
        jsonObject.put("current", pages.getCurrent());
        jsonObject.put("size", pages.getSize());
        jsonObject.put("pages", pages.getPages());
        return jsonObject;
    }


}
