package com.ejianc.business.car.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 车辆信息
 *
 * @author generator
 *
 */
@TableName("ejc_car_car")
public class CarEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "car_type_id")
    private Long carTypeId; // 车辆类型
    @TableField(value = "car_type_name")
    private String carTypeName; // 车辆类型
    @TableField(value = "car_model_id")
    private Long carModelId; // 型号
    @TableField(value = "car_model_name")
    private String carModelName; // 型号
    @TableField(value = "car_name")
    private String carName; // 设备名称
    @TableField(value = "code")
    private String code; // 车牌号
    @TableField(value = "org_id")
    private Long orgId; // 所属公司
    @TableField(value = "org_name")
    private String orgName; // 所属公司
    @TableField(value = "brand")
    private String brand; // 品牌

    @TableField(value = "vin_no")
    private String vinNo; // 车架号

    @TableField(value = "engine_no")
    private String engineNo; // 发动机号

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "regist_date")
    private Date registDate; // 注册日期

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "cert_date")
    private Date certDate; // 发证日期
    @TableField(value = "total_weight")
    private BigDecimal totalWeight; // 总质量
    @TableField(value = "all_weight")
    private BigDecimal allWeight; // 整备质量
    @TableField(value = "check_weight")
    private BigDecimal checkWeight; // 核定载质量
    @TableField(value = "buy_price")
    private BigDecimal buyPrice; // 购车价

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "year_check_date")
    private Date yearCheckDate; // 年检时间

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "insure_force_date")
    private Date insureForceDate; // 保险时间(强制险)

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "insure_business_date")
    private Date insureBusinessDate; // 保险时间(商业险)
    @TableField(value = "oil_card")
    private String oilCard; // 油卡号
    @TableField(value = "car_area_id")
    private Long carAreaId; // 车辆所在区域
    @TableField(value = "car_area_name")
    private String carAreaName; // 车辆所在区域
    @TableField(value = "car_project_id")
    private Long carProjectId; // 所属项目
    @TableField(value = "car_project_name")
    private String carProjectName; // 所属项目
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人
    @TableField(value = "department_name")
    private String departmentName; // 经办部门
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态


    public Long getCarTypeId() {
        return carTypeId;
    }

    public void setCarTypeId(Long carTypeId) {
        this.carTypeId = carTypeId;
    }

    public String getCarTypeName() {
        return carTypeName;
    }

    public void setCarTypeName(String carTypeName) {
        this.carTypeName = carTypeName;
    }

    public Long getCarModelId() {
        return carModelId;
    }

    public void setCarModelId(Long carModelId) {
        this.carModelId = carModelId;
    }

    public String getCarModelName() {
        return carModelName;
    }

    public void setCarModelName(String carModelName) {
        this.carModelName = carModelName;
    }

    public String getCarName() {
        return carName;
    }

    public void setCarName(String carName) {
        this.carName = carName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getVinNo() {
        return vinNo;
    }

    public void setVinNo(String vinNo) {
        this.vinNo = vinNo;
    }

    public String getEngineNo() {
        return engineNo;
    }

    public void setEngineNo(String engineNo) {
        this.engineNo = engineNo;
    }

    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public Date getCertDate() {
        return certDate;
    }

    public void setCertDate(Date certDate) {
        this.certDate = certDate;
    }

    public BigDecimal getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    public BigDecimal getAllWeight() {
        return allWeight;
    }

    public void setAllWeight(BigDecimal allWeight) {
        this.allWeight = allWeight;
    }

    public BigDecimal getCheckWeight() {
        return checkWeight;
    }

    public void setCheckWeight(BigDecimal checkWeight) {
        this.checkWeight = checkWeight;
    }

    public BigDecimal getBuyPrice() {
        return buyPrice;
    }

    public void setBuyPrice(BigDecimal buyPrice) {
        this.buyPrice = buyPrice;
    }

    public Date getYearCheckDate() {
        return yearCheckDate;
    }

    public void setYearCheckDate(Date yearCheckDate) {
        this.yearCheckDate = yearCheckDate;
    }

    public Date getInsureForceDate() {
        return insureForceDate;
    }

    public void setInsureForceDate(Date insureForceDate) {
        this.insureForceDate = insureForceDate;
    }

    public Date getInsureBusinessDate() {
        return insureBusinessDate;
    }

    public void setInsureBusinessDate(Date insureBusinessDate) {
        this.insureBusinessDate = insureBusinessDate;
    }

    public String getOilCard() {
        return oilCard;
    }

    public void setOilCard(String oilCard) {
        this.oilCard = oilCard;
    }

    public Long getCarAreaId() {
        return carAreaId;
    }

    public void setCarAreaId(Long carAreaId) {
        this.carAreaId = carAreaId;
    }

    public String getCarAreaName() {
        return carAreaName;
    }

    public void setCarAreaName(String carAreaName) {
        this.carAreaName = carAreaName;
    }

    public Long getCarProjectId() {
        return carProjectId;
    }

    public void setCarProjectId(Long carProjectId) {
        this.carProjectId = carProjectId;
    }

    public String getCarProjectName() {
        return carProjectName;
    }

    public void setCarProjectName(String carProjectName) {
        this.carProjectName = carProjectName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

}
