package com.ejianc.business.car.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.car.bean.OilRecordDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 用油记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_car_oil_record")
public class OilRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="car_code")
    private String carCode; // 车牌号
    @TableField(value="car_id")
    private Long carId; // 车牌号
    @TableField(value="car_name")
    private String carName; // 车辆名称
    @TableField(value="car_area_id")
    private Long carAreaId; // 车辆所在区域
    @TableField(value="car_area_name")
    private String carAreaName; // 车辆所在区域
    @TableField(value="car_project_id")
    private Long carProjectId; // 车辆所在项目
    @TableField(value="car_project_name")
    private String carProjectName; // 车辆所在项目
    @TableField(value="month_date")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date monthDate; // 月份
    @TableField(value="total_oil_consumption")
    private BigDecimal totalOilConsumption; // 总油耗量
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属公司
    @TableField(value="org_name")
    private String orgName; // 所属公司
    @TableField(value="car_org_id")
    private Long carOrgId; // 车辆所属公司
    @TableField(value="car_org_name")
    private String carOrgName; // 车辆所属公司
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="oilRecordDetailService", pidName = "recordId")
    private List<OilRecordDetailEntity> oilRecordDetailList = new ArrayList<>(); // 用油记录详情

    public Long getCarId() {
        return carId;
    }

    public void setCarId(Long carId) {
        this.carId = carId;
    }

    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }

    public String getCarName() {
        return carName;
    }

    public void setCarName(String carName) {
        this.carName = carName;
    }
    public Long getCarAreaId() {
        return carAreaId;
    }

    public void setCarAreaId(Long carAreaId) {
        this.carAreaId = carAreaId;
    }
    public String getCarAreaName() {
        return carAreaName;
    }

    public void setCarAreaName(String carAreaName) {
        this.carAreaName = carAreaName;
    }
    public Long getCarProjectId() {
        return carProjectId;
    }

    public void setCarProjectId(Long carProjectId) {
        this.carProjectId = carProjectId;
    }
    public String getCarProjectName() {
        return carProjectName;
    }

    public Long getCarOrgId() {
        return carOrgId;
    }

    public void setCarOrgId(Long carOrgId) {
        this.carOrgId = carOrgId;
    }

    public String getCarOrgName() {
        return carOrgName;
    }

    public void setCarOrgName(String carOrgName) {
        this.carOrgName = carOrgName;
    }

    public void setCarProjectName(String carProjectName) {
        this.carProjectName = carProjectName;
    }
    public Date getMonthDate() {
        return monthDate;
    }

    public void setMonthDate(Date monthDate) {
        this.monthDate = monthDate;
    }
    public BigDecimal getTotalOilConsumption() {
        return totalOilConsumption;
    }

    public void setTotalOilConsumption(BigDecimal totalOilConsumption) {
        this.totalOilConsumption = totalOilConsumption;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    

    public List<OilRecordDetailEntity> getOilRecordDetailList() {
        return oilRecordDetailList;
    }

    public void setOilRecordDetailList(List<OilRecordDetailEntity> oilRecordDetailList) {
        this.oilRecordDetailList = oilRecordDetailList;
    }
}
